<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_tv_activity_riwayat extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//PAGING
		$page_number = $this->input->post("page_number", true);
		$paging = $page_number * 20 - (20);
		if ($paging == '1') {
			$paging = 0;
		}

		//FILTER
		$trx_tv_tanggal_awal = $this->trx_tv_tanggal_awal();
		$trx_tv_tanggal_akhir = $this->trx_tv_tanggal_akhir();

		//FILTER
		if (strlen($trx_tv_tanggal_awal) > 1 && strlen($trx_tv_tanggal_akhir) > 1) {
			//PANGGIL DATA
			$tv = $this->db->query("SELECT * FROM tbl_trx_tv WHERE 
								trx_tv_user_kode='$mst_user_kode' AND
								trx_tv_tanggal BETWEEN '$trx_tv_tanggal_awal 00:00:00' and '$trx_tv_tanggal_akhir 23:59:59'
								ORDER BY trx_tv_id desc
								limit 20 offset $paging");
		} else {
			//PANGGIL DATA
			$tv = $this->db->query("SELECT * FROM tbl_trx_tv WHERE 
								trx_tv_user_kode='$mst_user_kode'
								ORDER BY trx_tv_id desc
								limit 20 offset $paging");
		}

		if ($tv->num_rows() > 0) {
			foreach ($tv->result() as $row) {
				$data['riwayat'][] = array(
					'trx_tv_kode' => encrypt($row->trx_tv_kode, $this->config->item('key')),
					'trx_tv_user_kode' => encrypt($row->trx_tv_user_kode, $this->config->item('key')),
					'trx_tv_kategori_kode' => encrypt($row->trx_tv_kategori_kode, $this->config->item('key')),
					'trx_tv_kategori_nama' => encrypt($row->trx_tv_kategori_nama, $this->config->item('key')),
					'trx_tv_nomor' => encrypt($row->trx_tv_nomor, $this->config->item('key')),
					'trx_tv_nama' => encrypt($row->trx_tv_nama, $this->config->item('key')),
					'trx_tv_admin' => encrypt(number_format($row->trx_tv_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_tv_harga' => encrypt(number_format($row->trx_tv_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_tv_total' => encrypt(number_format($row->trx_tv_admin + $row->trx_tv_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_tv_lembar_tagihan' => encrypt($row->trx_tv_lembar_tagihan, $this->config->item('key')),
					'trx_tv_periode' => encrypt($row->trx_tv_periode, $this->config->item('key')),
					'trx_tv_sn' => encrypt($row->trx_tv_sn, $this->config->item('key')),
					'trx_tv_keterangan' => encrypt($row->trx_tv_keterangan, $this->config->item('key')),
					'trx_tv_notasi' => encrypt($row->trx_tv_notasi, $this->config->item('key')),
					'trx_tv_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_tv_tanggal)), $this->config->item('key')),
					'trx_tv_icon' => encrypt($row->trx_tv_icon, $this->config->item('key')),
					'trx_tv_rc' => encrypt($row->trx_tv_rc, $this->config->item('key')),
					'trx_tv_status' => encrypt($row->trx_tv_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal menampilkan data, silahkan refresh halaman secara berkala atau hubungi customer service jika masih terjadi kendala!";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_tv_tanggal_awal()
	{
		$input = decrypt($this->input->post("trx_tv_tanggal_awal", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_tv_tanggal_akhir()
	{
		$input = decrypt($this->input->post("trx_tv_tanggal_akhir", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
