<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_tapcash_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$tapcash = $this->db->query("SELECT * FROM tbl_mst_tapcash  order by mst_tapcash_urutan asc");

		if ($tapcash->num_rows() > 0) {
			foreach ($tapcash->result() as $row) {
				$data['tapcash'][] = array(
					'mst_tapcash_kode' => encrypt($row->mst_tapcash_kode, $this->config->item('key')),
					'mst_tapcash_nama' => encrypt($row->mst_tapcash_nama, $this->config->item('key')),
					'mst_tapcash_keterangan' => encrypt($row->mst_tapcash_keterangan, $this->config->item('key')),
					'mst_tapcash_notasi' => encrypt($row->mst_tapcash_notasi, $this->config->item('key')),
					'mst_tapcash_harga' => encrypt(number_format($row->mst_tapcash_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_tapcash_admin' => encrypt(number_format($row->mst_tapcash_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_tapcash_total' => encrypt(number_format($row->mst_tapcash_harga + $row->mst_tapcash_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_tapcash_poin' => encrypt($row->mst_tapcash_poin, $this->config->item('key')),
					'mst_tapcash_urutan' => encrypt($row->mst_tapcash_urutan, $this->config->item('key')),
					'mst_tapcash_status' => encrypt($row->mst_tapcash_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
