<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_shopeepay_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$shopeepay = $this->db->query("SELECT * FROM tbl_mst_shopeepay  order by mst_shopeepay_urutan asc");

		if ($shopeepay->num_rows() > 0) {
			foreach ($shopeepay->result() as $row) {
				$data['shopeepay'][] = array(
					'mst_shopeepay_kode' => encrypt($row->mst_shopeepay_kode, $this->config->item('key')),
					'mst_shopeepay_nama' => encrypt($row->mst_shopeepay_nama, $this->config->item('key')),
					'mst_shopeepay_keterangan' => encrypt($row->mst_shopeepay_keterangan, $this->config->item('key')),
					'mst_shopeepay_notasi' => encrypt($row->mst_shopeepay_notasi, $this->config->item('key')),
					'mst_shopeepay_harga' => encrypt(number_format($row->mst_shopeepay_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_shopeepay_admin' => encrypt(number_format($row->mst_shopeepay_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_shopeepay_total' => encrypt(number_format($row->mst_shopeepay_harga + $row->mst_shopeepay_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_shopeepay_poin' => encrypt($row->mst_shopeepay_poin, $this->config->item('key')),
					'mst_shopeepay_urutan' => encrypt($row->mst_shopeepay_urutan, $this->config->item('key')),
					'mst_shopeepay_status' => encrypt($row->mst_shopeepay_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
