<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_main_activity_update extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		$update = $this->db->query("SELECT * FROM tbl_mst_update WHERE mst_update_status='0'");
		if ($update->num_rows() > 0) {
			foreach ($update->result() as $row) {
				$data['update'][] = array(
					'mst_update_kode' => encrypt($row->mst_update_kode, $this->config->item('key')),
					'mst_update_tipe' => encrypt($row->mst_update_tipe, $this->config->item('key')),
					'mst_update_versi' => encrypt($row->mst_update_versi, $this->config->item('key')),
					'mst_update_judul' => encrypt($row->mst_update_judul, $this->config->item('key')),
					'mst_update_isi' => encrypt($row->mst_update_isi, $this->config->item('key')),
					'mst_update_status' => encrypt($row->mst_update_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Update muncul";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Update tidak muncul";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
