<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_googleplay_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$googleplay = $this->db->query("SELECT * FROM tbl_mst_googleplay  order by mst_googleplay_urutan asc");

		if ($googleplay->num_rows() > 0) {
			foreach ($googleplay->result() as $row) {
				$data['googleplay'][] = array(
					'mst_googleplay_kode' => encrypt($row->mst_googleplay_kode, $this->config->item('key')),
					'mst_googleplay_nama' => encrypt($row->mst_googleplay_nama, $this->config->item('key')),
					'mst_googleplay_keterangan' => encrypt($row->mst_googleplay_keterangan, $this->config->item('key')),
					'mst_googleplay_notasi' => encrypt($row->mst_googleplay_notasi, $this->config->item('key')),
					'mst_googleplay_harga' => encrypt(number_format($row->mst_googleplay_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_googleplay_admin' => encrypt(number_format($row->mst_googleplay_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_googleplay_total' => encrypt(number_format($row->mst_googleplay_harga + $row->mst_googleplay_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_googleplay_poin' => encrypt($row->mst_googleplay_poin, $this->config->item('key')),
					'mst_googleplay_urutan' => encrypt($row->mst_googleplay_urutan, $this->config->item('key')),
					'mst_googleplay_status' => encrypt($row->mst_googleplay_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
