<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_emoney_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$emoney = $this->db->query("SELECT * FROM tbl_mst_emoney  order by mst_emoney_urutan asc");

		if ($emoney->num_rows() > 0) {
			foreach ($emoney->result() as $row) {
				$data['emoney'][] = array(
					'mst_emoney_kode' => encrypt($row->mst_emoney_kode, $this->config->item('key')),
					'mst_emoney_nama' => encrypt($row->mst_emoney_nama, $this->config->item('key')),
					'mst_emoney_keterangan' => encrypt($row->mst_emoney_keterangan, $this->config->item('key')),
					'mst_emoney_notasi' => encrypt($row->mst_emoney_notasi, $this->config->item('key')),
					'mst_emoney_harga' => encrypt(number_format($row->mst_emoney_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_emoney_admin' => encrypt(number_format($row->mst_emoney_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_emoney_total' => encrypt(number_format($row->mst_emoney_harga + $row->mst_emoney_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_emoney_poin' => encrypt($row->mst_emoney_poin, $this->config->item('key')),
					'mst_emoney_urutan' => encrypt($row->mst_emoney_urutan, $this->config->item('key')),
					'mst_emoney_status' => encrypt($row->mst_emoney_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
