<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_deposit_activity_manual extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");

		//DEPOSIT
		$trx_deposit_jumlah = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->trx_deposit_jumlah());


		//DEPOSIT
		$deposit = $this->db->query("SELECT * FROM tbl_mst_deposit_manual");
		if ($deposit->num_rows() > 0) {
			foreach ($deposit->result() as $key => $row) {
				$mst_deposit_admin[$key] = $row->mst_deposit_admin;
				$mst_deposit_total[$key] = $trx_deposit_jumlah + $mst_deposit_admin[$key];

				$data['deposit'][] = array(
					'mst_deposit_kode' => encrypt($row->mst_deposit_kode, $this->config->item('key')),
					'mst_deposit_nama_bank' => encrypt($row->mst_deposit_nama_bank, $this->config->item('key')),
					'mst_deposit_nomor_rekening' => encrypt($row->mst_deposit_nomor_rekening, $this->config->item('key')),
					'mst_deposit_nama_rekening' => encrypt($row->mst_deposit_nama_rekening, $this->config->item('key')),
					'mst_deposit_jumlah' => encrypt(number_format($trx_deposit_jumlah, 0, ',', '.'), $this->config->item('key')),
					'mst_deposit_admin' => encrypt(number_format($row->mst_deposit_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_deposit_total' => encrypt(number_format($mst_deposit_total[$key], 0, ',', '.'), $this->config->item('key')),
					'mst_deposit_keterangan' => encrypt($row->mst_deposit_keterangan, $this->config->item('key')),
					'mst_deposit_notasi' => encrypt($row->mst_deposit_notasi, $this->config->item('key')),
					'mst_deposit_icon' => encrypt($row->mst_deposit_icon, $this->config->item('key')),
					'mst_deposit_status' => encrypt($row->mst_deposit_status, $this->config->item('key')),
				);
				array_multisort($mst_deposit_total, SORT_ASC, $data['deposit']);
			}


			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function trx_deposit_jumlah()
	{
		$input = decrypt($this->input->post("trx_deposit_jumlah", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
