<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_dana_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$dana = $this->db->query("SELECT * FROM tbl_mst_dana  order by mst_dana_urutan asc");

		if ($dana->num_rows() > 0) {
			foreach ($dana->result() as $row) {
				$data['dana'][] = array(
					'mst_dana_kode' => encrypt($row->mst_dana_kode, $this->config->item('key')),
					'mst_dana_nama' => encrypt($row->mst_dana_nama, $this->config->item('key')),
					'mst_dana_keterangan' => encrypt($row->mst_dana_keterangan, $this->config->item('key')),
					'mst_dana_notasi' => encrypt($row->mst_dana_notasi, $this->config->item('key')),
					'mst_dana_harga' => encrypt(number_format($row->mst_dana_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_dana_admin' => encrypt(number_format($row->mst_dana_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_dana_total' => encrypt(number_format($row->mst_dana_harga + $row->mst_dana_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_dana_poin' => encrypt($row->mst_dana_poin, $this->config->item('key')),
					'mst_dana_urutan' => encrypt($row->mst_dana_urutan, $this->config->item('key')),
					'mst_dana_status' => encrypt($row->mst_dana_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
