<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_bonus_activity_pilihan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");

		$bonus = $this->db->query("SELECT * FROM tbl_mst_bonus");
		if ($bonus->num_rows() > 0) {
			foreach ($bonus->result() as $row) {
				$data['bonus'][] = array(
					'mst_bonus_kode' => encrypt($row->mst_bonus_kode, $this->config->item('key')),
					'mst_bonus_nama' => encrypt($row->mst_bonus_nama, $this->config->item('key')),
					'mst_bonus_poin' => encrypt($row->mst_bonus_poin, $this->config->item('key')),
					'mst_bonus_admin' => encrypt(number_format($row->mst_bonus_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_bonus_harga' => encrypt(number_format($row->mst_bonus_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_bonus_total' => encrypt(number_format($row->mst_bonus_admin + $row->mst_bonus_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_bonus_keterangan' => encrypt($row->mst_bonus_keterangan, $this->config->item('key')),
					'mst_bonus_notasi' => encrypt($row->mst_bonus_notasi, $this->config->item('key')),
					'mst_bonus_status' => encrypt($row->mst_bonus_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
