<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">MENU</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" onclick="aksi_reload()"><i class="fas fa-sync-alt"></i></button>
                    </div>
                </div>
                <div class="card-body">
                    <a class="btn btn-primary" onclick="aksi_tambah_modal()">Tambah</a> &nbsp;
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_menu">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>
            <form enctype="multipart/form-data" id="submit">
                <div class="modal-header">
                    <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                    <button type="button" class="close" onclick="aksi_tutup_modal()" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Kode</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="mst_menu_kode" name="mst_menu_kode" placeholder="Kode menu">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Grup</label>
                                <div class="col-lg-9">
                                    <select required class="form-control select2bs4 col-sm-2" style="width: 100%;" id="mst_menu_grup" name='mst_menu_grup' required>Pilih Status
                                        <option value="Isi Ulang">Isi Ulang</option>
                                        <option value="Bayar Tagihan">Bayar Tagihan</option>
                                        <option value="Dompet Digital">Dompet Digital</option>
                                        <option value="Saldo Driver">Saldo Driver</option>
                                        <option value="Voucher">Voucher</option>
                                        <option value="Uang Elektronik">Uang Elektronik</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Nama</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="mst_menu_nama" name="mst_menu_nama" placeholder="Nama menu">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Tipe</label>
                                <div class="col-lg-9">
                                    <select required class="form-control select2bs4 col-sm-2" style="width: 100%;" id="mst_menu_tipe" name='mst_menu_tipe' required>Pilih Status
                                        <option value="Activity">Activity</option>
                                        <option value="Webview">Webview</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Icon</label>
                                <div class="col-lg-9">
                                    <input type="file" class="form-control" id="mst_menu_icon" name="mst_menu_icon">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Link</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="mst_menu_link" name="mst_menu_link" placeholder="Nama menu">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Urutan</label>
                                <div class="col-lg-9">
                                    <input type="number" class="form-control" id="mst_menu_urutan" name="mst_menu_urutan" placeholder="Urutan tampil">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Keterangan</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="mst_menu_keterangan" name="mst_menu_keterangan" placeholder="Keterangan">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Notasi</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="mst_menu_notasi" name="mst_menu_notasi" placeholder="Notasi khusus (promo, cara pakai dll)">
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                    <button type="submit" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>

<script type='text/javascript'>
    var submit_status;
    $(document).ready(function() {
        aksi_data();

        //SELECT2
        $('.select2').select2()
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });

    $('#submit').submit(function(e) {
        e.preventDefault();
        var mst_menu_kode = $("#mst_menu_kode").val();
        var mst_menu_grup = $("#mst_menu_grup").val();
        var mst_menu_nama = $("#mst_menu_nama").val();
        var mst_menu_tipe = $("#mst_menu_tipe").val();
        var mst_menu_icon = $("#mst_menu_icon").val();
        var mst_menu_link = $("#mst_menu_link").val();
        var mst_menu_urutan = $("#mst_menu_urutan").val();
        var mst_menu_keterangan = $("#mst_menu_keterangan").val();
        var mst_menu_notasi = $("#mst_menu_notasi").val();

        //EDIT
        if (submit_status == 'Edit') {
            if (mst_menu_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_grup.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_nama.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_tipe.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_link.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_urutan.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                $.ajax({
                    url: '<?php echo base_url() ?>menu/aksi_edit',
                    type: "POST",
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        toastr.success('Menu berhasil di edit');

                        //SET VALUE
                        document.getElementById("mst_menu_kode").value = '';
                        $("#mst_menu_grup").val('').trigger("change");
                        document.getElementById("mst_menu_nama").value = '';
                        $("#mst_menu_tipe").val('').trigger("change");
                        document.getElementById("mst_menu_icon").value = '';
                        document.getElementById("mst_menu_link").value = '';
                        document.getElementById("mst_menu_icon").value = '';
                        document.getElementById("mst_menu_urutan").value = '';
                        document.getElementById("mst_menu_keterangan").value = '';
                        document.getElementById("mst_menu_notasi").value = '';

                        //LOADING
                        document.getElementById("modal_loading").style.visibility = "hidden";

                        //MODAL
                        $("#modal_menu").modal('hide');

                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Menu gagal di edit');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

        //TAMBAH
        if (submit_status == 'Tambah') {
            if (mst_menu_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_grup.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_nama.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_tipe.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_link.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_menu_urutan.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                $.ajax({
                    url: '<?php echo base_url() ?>menu/aksi_tambah',
                    type: "POST",
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var tambah_status = obj.tambah_status;

                        if (tambah_status == '0') {
                            toastr.success('Menu berhasil di tambahkan');

                            //SET VALUE
                            document.getElementById("mst_menu_kode").value = '';
                            $("#mst_menu_grup").val('').trigger("change");
                            document.getElementById("mst_menu_nama").value = '';
                            $("#mst_menu_tipe").val('').trigger("change");
                            document.getElementById("mst_menu_icon").value = '';
                            document.getElementById("mst_menu_link").value = '';
                            document.getElementById("mst_menu_icon").value = '';
                            document.getElementById("mst_menu_urutan").value = '';
                            document.getElementById("mst_menu_keterangan").value = '';
                            document.getElementById("mst_menu_notasi").value = '';

                            //LOADING
                            document.getElementById("modal_loading").style.visibility = "hidden";

                            aksi_data();
                        } else {
                            toastr.error('Menu gagal di tambahkan karena kode menu sudah pernah ditambahkan sebelumnya!');
                            document.getElementById("modal_loading").style.visibility = "hidden";
                        }

                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Menu gagal di tambahkan');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>menu/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_reload() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>menu/aksi_reload',
            success: function() {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                aksi_data();
            }
        })
    }

    function aksi_edit_modal(element) {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var $row = $(element).closest("tr");
        var mst_menu_kode = $row.find("#tbl_mst_menu_kode").text();;
        var mst_menu_grup = $row.find("#tbl_mst_menu_grup").text();
        var mst_menu_nama = $row.find("#tbl_mst_menu_nama").text();;
        var mst_menu_tipe = $row.find("#tbl_mst_menu_tipe").text();
        var mst_menu_icon = $row.find("#tbl_mst_menu_icon").text();;
        var mst_menu_link = $row.find("#tbl_mst_menu_link").text();
        var mst_menu_urutan = $row.find("#tbl_mst_menu_urutan").text();
        var mst_menu_keterangan = $row.find("#tbl_mst_menu_keterangan").text();
        var mst_menu_notasi = $row.find("#tbl_mst_menu_notasi").text();

        //SET VALUE
        document.getElementById("mst_menu_kode").value = mst_menu_kode;
        $("#mst_menu_grup").val(mst_menu_grup).trigger("change");
        document.getElementById("mst_menu_nama").value = mst_menu_nama;
        $("#mst_menu_tipe").val(mst_menu_tipe).trigger("change");
        document.getElementById("mst_menu_icon").value = mst_menu_icon;
        document.getElementById("mst_menu_link").value = mst_menu_link;
        document.getElementById("mst_menu_urutan").value = mst_menu_urutan;
        document.getElementById("mst_menu_keterangan").value = mst_menu_keterangan;
        document.getElementById("mst_menu_notasi").value = mst_menu_notasi;

        //DISABLE VALUE
        document.getElementById("mst_menu_kode").readOnly = true;

        //SET STATUS
        submit_status = 'Edit';

        //SET TITLE
        $("#modal_title").html('EDIT MENU');

        //SHOW MODAL
        $('#modal_menu').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tambah_modal() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        //SET TITLE
        $("#modal_title").html('TAMBAH MENU');

        //ENABLE VALUE
        document.getElementById("mst_menu_kode").readOnly = false;

        //SET VALUE
        document.getElementById("mst_menu_kode").value = '';
        $("#mst_menu_grup").val('').trigger("change");
        document.getElementById("mst_menu_nama").value = '';
        $("#mst_menu_tipe").val('').trigger("change");
        document.getElementById("mst_menu_icon").value = '';
        document.getElementById("mst_menu_link").value = '';
        document.getElementById("mst_menu_icon").value = '';
        document.getElementById("mst_menu_urutan").value = '';
        document.getElementById("mst_menu_keterangan").value = '';
        document.getElementById("mst_menu_notasi").value = '';

        //SET STATUS
        submit_status = 'Tambah';

        //SHOW MODAL
        $('#modal_menu').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tidak_tampil(mst_menu_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>menu/aksi_tidak_tampil/' + mst_menu_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status menu menjadi hilang');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status menu menjadi tidak aktif');
            }
        });
    }


    function aksi_tidak_aktif(mst_menu_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>menu/aksi_tidak_aktif/' + mst_menu_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status menu menjadi tidak aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status menu menjadi tidak aktif');
            }
        });
    }

    function aksi_aktif(mst_menu_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>menu/aksi_aktif/' + mst_menu_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status menu menjadi aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status menu menjadi tidak aktif');
            }
        });
    }

    function aksi_hapus(mst_menu_kode) {
        Swal.fire({
            title: 'Yakin ingin menghapus menu?',
            text: "Setelah menghapus, data tidak bisa dikembalikan lagi!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>menu/aksi_hapus/' + mst_menu_kode,
                    type: "POST",
                    success: function() {
                        toastr.success('Berhasil menghapus menu');
                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Gagal menghapus menu');
                    }
                });
            }
        })


    }

    function aksi_tutup_modal() {
        aksi_data();
        document.getElementById("modal_loading").style.visibility = "hidden";
        $("#modal_menu").modal('hide');
    }
</script>