<?php

class Model_transaksi_token_pln extends CI_Model
{

    var $column_order = array('mst_user_kode', 'mst_user_nama_lengkap', 'trx_token_pln_tanggal');
    var $column_search = array(
        'trx_token_pln_kode', 'trx_token_pln_user_kode', 'trx_token_pln_pelanggan_nomor',
        'trx_token_pln_pelanggan_id',  'trx_token_pln_nama', 'trx_token_pln_tanggal', 'mst_user_nama_lengkap'
    );
    var $order = array('trx_token_pln_tanggal' => 'desc');

    //FILTER BERDASARKAN TANGGAL
    private function _get_datatables_query_tanggal($tanggal_awal, $tanggal_akhir)
    {
        $this->load->database('db_arifahpulsa_api', true);
        $this->db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', true);

        $this->db_arifahpulsa_api->select("mst_user_nama_lengkap,
                                        trx_token_pln_kode,trx_token_pln_user_kode,
                                        trx_token_pln_pelanggan_nomor,trx_token_pln_pelanggan_id,
                                        trx_token_pln_pelanggan_nama,trx_token_pln_pelanggan_segment,
                                        trx_token_pln_pelanggan_daya,
                                        trx_token_pln_nama,trx_token_pln_admin,
                                        trx_token_pln_harga,trx_token_pln_poin,trx_token_pln_sn,
                                        trx_token_pln_keterangan,trx_token_pln_notasi,trx_token_pln_tanggal,
                                        trx_token_pln_icon,trx_token_pln_rc,trx_token_pln_status")
            ->from("tbl_trx_token_pln, tbl_mst_user")
            ->where("trx_token_pln_user_kode=mst_user_kode
                    and trx_token_pln_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");

        $i = 0;
        foreach ($this->column_search as $item) // looping awal
        {
            if ($_POST['search']['value']) {
                if ($i === 0) {
                    $this->db_arifahpulsa_api->group_start();
                    $this->db_arifahpulsa_api->like($item, $_POST['search']['value']);
                } else {
                    $this->db_arifahpulsa_api->or_like($item, $_POST['search']['value']);
                }

                if (count($this->column_search) - 1 == $i)
                    $this->db_arifahpulsa_api->group_end();
            }
            $i++;
        }

        if (isset($_POST['order'])) {
            $this->db_arifahpulsa_api->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db_arifahpulsa_api->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables_tanggal($tanggal_awal, $tanggal_akhir)
    {
        $this->_get_datatables_query_tanggal($tanggal_awal, $tanggal_akhir);
        if ($_POST['length'] != -1) {
            $this->db_arifahpulsa_api->limit($_POST['length'], $_POST['start']);
            $query = $this->db_arifahpulsa_api->get();
        }
        return $query->result();
    }


    function count_filtered_tanggal($tanggal_awal, $tanggal_akhir)
    {
        $this->_get_datatables_query_tanggal($tanggal_awal, $tanggal_akhir);
        $query =  $this->db_arifahpulsa_api->get();
        return $query->num_rows();
    }

    public function count_all_tanggal($tanggal_awal, $tanggal_akhir)
    {
        $this->db_arifahpulsa_api->select("mst_user_nama_lengkap,
                                        trx_token_pln_kode,trx_token_pln_user_kode,
                                        trx_token_pln_pelanggan_nomor,trx_token_pln_pelanggan_id,
                                        trx_token_pln_pelanggan_nama,trx_token_pln_pelanggan_segment,
                                        trx_token_pln_pelanggan_daya,
                                        trx_token_pln_nama,trx_token_pln_admin,
                                        trx_token_pln_harga,trx_token_pln_poin,trx_token_pln_sn,
                                        trx_token_pln_keterangan,trx_token_pln_notasi,trx_token_pln_tanggal,
                                        trx_token_pln_icon,trx_token_pln_rc,trx_token_pln_status")
            ->from("tbl_trx_token_pln, tbl_mst_user")
            ->where("trx_token_pln_user_kode=mst_user_kode
                    and trx_token_pln_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");
        return $this->db_arifahpulsa_api->count_all_results();
    }


    //FILTER BERDASARKAN PENCARIAN
    private function _get_datatables_query_cari($txt_cari)
    {
        $this->load->database('db_arifahpulsa_api', true);
        $this->db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', true);

        $this->db_arifahpulsa_api->select("mst_user_nama_lengkap,
                                        trx_token_pln_kode,trx_token_pln_user_kode,
                                        trx_token_pln_pelanggan_nomor,trx_token_pln_pelanggan_id,
                                        trx_token_pln_pelanggan_nama,trx_token_pln_pelanggan_segment,
                                        trx_token_pln_pelanggan_daya,
                                        trx_token_pln_nama,trx_token_pln_admin,
                                        trx_token_pln_harga,trx_token_pln_poin,trx_token_pln_sn,
                                        trx_token_pln_keterangan,trx_token_pln_notasi,trx_token_pln_tanggal,
                                        trx_token_pln_icon,trx_token_pln_rc,trx_token_pln_status")
            ->from("tbl_trx_token_pln, tbl_mst_user")
            ->where("trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_kode LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_nama LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_pelanggan_nomor LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_pelanggan_id LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_pelanggan_nama LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_status LIKE '%$txt_cari%'");

        $i = 0;
        foreach ($this->column_search as $item) // looping awal
        {
            if ($_POST['search']['value']) {
                if ($i === 0) {
                    $this->db_arifahpulsa_api->group_start();
                    $this->db_arifahpulsa_api->like($item, $_POST['search']['value']);
                } else {
                    $this->db_arifahpulsa_api->or_like($item, $_POST['search']['value']);
                }

                if (count($this->column_search) - 1 == $i)
                    $this->db_arifahpulsa_api->group_end();
            }
            $i++;
        }

        if (isset($_POST['order'])) {
            $this->db_arifahpulsa_api->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db_arifahpulsa_api->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables_cari($txt_cari)
    {
        $this->_get_datatables_query_cari($txt_cari);
        if ($_POST['length'] != -1) {
            $this->db_arifahpulsa_api->limit($_POST['length'], $_POST['start']);
            $query = $this->db_arifahpulsa_api->get();
        }
        return $query->result();
    }


    function count_filtered_cari($txt_cari)
    {
        $this->_get_datatables_query_cari($txt_cari);
        $query =  $this->db_arifahpulsa_api->get();
        return $query->num_rows();
    }

    public function count_all_cari($txt_cari)
    {
        $this->db_arifahpulsa_api->select("mst_user_nama_lengkap,
                                        trx_token_pln_kode,trx_token_pln_user_kode,
                                        trx_token_pln_pelanggan_nomor,trx_token_pln_pelanggan_id,
                                        trx_token_pln_pelanggan_nama,trx_token_pln_pelanggan_segment,
                                        trx_token_pln_pelanggan_daya,
                                        trx_token_pln_nama,trx_token_pln_admin,
                                        trx_token_pln_harga,trx_token_pln_poin,trx_token_pln_sn,
                                        trx_token_pln_keterangan,trx_token_pln_notasi,trx_token_pln_tanggal,
                                        trx_token_pln_icon,trx_token_pln_rc,trx_token_pln_status")
            ->from("tbl_trx_token_pln, tbl_mst_user")
            ->where("trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_kode LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_nama LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_pelanggan_nomor LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_pelanggan_id LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_pelanggan_nama LIKE '%$txt_cari%'
                    OR
                    trx_token_pln_user_kode=mst_user_kode and 
                    trx_token_pln_status LIKE '%$txt_cari%'");
        return $this->db_arifahpulsa_api->count_all_results();
    }
}
