<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Master_tokopedia extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_tokopedia');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Master Tokopedia';

        $this->template->load('includes/header', 'master/view_master_tokopedia', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_tokopedia');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_tokopedia 
                                          ORDER BY mst_tokopedia_urutan ASC ");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>NAMA</th>
                        <th>ADMIN</th>
                        <th>HARGA</th>
                        <th>JUAL</th>
                        <th>POIN</th>
                        <th>KETERANGAN</th>
                        <th>NOTASI</th>
                        <th>URUTAN</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            if ($row->mst_tokopedia_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_tokopedia_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->mst_tokopedia_kode . "')>SET TIDAK AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                           <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_tokopedia_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->mst_tokopedia_kode . "')>SET AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }


            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_mst_tokopedia_status'>$status</td>";
            echo            "<td id='tbl_mst_tokopedia_kode'>$row->mst_tokopedia_kode</td>";
            echo            "<td id='tbl_mst_tokopedia_nama'>$row->mst_tokopedia_nama</td>";
            echo            "<td id='tbl_mst_tokopedia_admin'>" . number_format($row->mst_tokopedia_admin, 0, ',', '.') . "</td> ";
            echo            "<td id='tbl_mst_tokopedia_harga'>" . number_format($row->mst_tokopedia_harga, 0, ',', '.') . "</td> ";
            echo            "<td id='tbl_mst_tokopedia_total'>" . number_format($row->mst_tokopedia_admin + $row->mst_tokopedia_harga, 0, ',', '.') . "</td> ";
            echo            "<td id='tbl_mst_tokopedia_poin'>$row->mst_tokopedia_poin</td>";
            echo            "<td id='tbl_mst_tokopedia_keterangan'>$row->mst_tokopedia_keterangan</td> ";
            echo            "<td id='tbl_mst_tokopedia_notasi'>$row->mst_tokopedia_notasi</td>";
            echo            "<td id='tbl_mst_tokopedia_urutan'>$row->mst_tokopedia_urutan</td> ";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
              
                $(document).ready(function () {
                    var table = $('#example1').DataTable({
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_reload()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_tokopedia');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url = "https://api.digiflazz.com/v1/price-list";

        $header = array(
            'Content-Type: text/plain',
        );

        $data = array(
            'cmd' => 'prepaid',
            'username' => $this->config->item('digiflazz_api_username'),
            'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . 'pricelist')
        );

        $json = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true)['data'];

        foreach ($response as $data) {
            //DIGIFLAZZ
            $buyer_sku_code = $data['buyer_sku_code'];
            $price = $data['price'];
            $seller_product_status = $data['seller_product_status'];
            $buyer_product_status = $data['buyer_product_status'];

            if ($seller_product_status === true && $buyer_product_status === true) {
                //AKTIF
                $tbl_mst_tokopedia[] = array(
                    'mst_tokopedia_kode' => $buyer_sku_code,
                    'mst_tokopedia_harga' =>  $price,
                    'mst_tokopedia_status' =>  '0'
                );
            } else {
                //TIDAK AKTIF
                $tbl_mst_tokopedia[] = array(
                    'mst_tokopedia_kode' => $buyer_sku_code,
                    'mst_tokopedia_harga' =>  $price,
                    'mst_tokopedia_status' =>  '1'
                );
            }
        }
        //UPDATE
        $db_arifahpulsa_api->update_batch('tbl_mst_tokopedia', $tbl_mst_tokopedia, 'mst_tokopedia_kode');
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_tokopedia/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_tokopedia_kode = $this->input->post("mst_tokopedia_kode");
        $mst_tokopedia_nama = $this->input->post("mst_tokopedia_nama");
        $mst_tokopedia_keterangan = $this->input->post("mst_tokopedia_keterangan");
        $mst_tokopedia_notasi = $this->input->post("mst_tokopedia_notasi");
        $mst_tokopedia_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_tokopedia_harga"));
        $mst_tokopedia_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_tokopedia_admin"));
        $mst_tokopedia_poin = $this->input->post("mst_tokopedia_poin");
        $mst_tokopedia_urutan = $this->input->post("mst_tokopedia_urutan");

        $db_arifahpulsa_api->query("UPDATE tbl_mst_tokopedia set
                                        mst_tokopedia_nama='" . str_replace("'", "\'", $mst_tokopedia_nama) . "',
                                        mst_tokopedia_keterangan='" . str_replace("'", "\'", $mst_tokopedia_keterangan) . "',
                                        mst_tokopedia_notasi='" . str_replace("'", "\'", $mst_tokopedia_notasi) . "',
                                        mst_tokopedia_harga='$mst_tokopedia_harga',
                                        mst_tokopedia_admin='$mst_tokopedia_admin',
                                        mst_tokopedia_poin='$mst_tokopedia_poin',
                                        mst_tokopedia_urutan='$mst_tokopedia_urutan'
                                        where  mst_tokopedia_kode='$mst_tokopedia_kode'");
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_tokopedia/tambah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_tokopedia_kode = $this->input->post("mst_tokopedia_kode");
        $mst_tokopedia_nama = $this->input->post("mst_tokopedia_nama");
        $mst_tokopedia_keterangan = $this->input->post("mst_tokopedia_keterangan");
        $mst_tokopedia_notasi = $this->input->post("mst_tokopedia_notasi");
        $mst_tokopedia_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_tokopedia_harga"));
        $mst_tokopedia_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_tokopedia_admin"));
        $mst_tokopedia_poin = $this->input->post("mst_tokopedia_poin");
        $mst_tokopedia_urutan = $this->input->post("mst_tokopedia_urutan");

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_mst_tokopedia where mst_tokopedia_kode='$mst_tokopedia_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {
            $db_arifahpulsa_api->query("insert into tbl_mst_tokopedia (
                                mst_tokopedia_kode,
								mst_tokopedia_nama, 
								mst_tokopedia_keterangan, 
								mst_tokopedia_notasi, 
								mst_tokopedia_harga,
								mst_tokopedia_admin,
								mst_tokopedia_poin,
								mst_tokopedia_urutan) values (
                                '$mst_tokopedia_kode', 
								'" . str_replace("'", "\'", $mst_tokopedia_nama) . "', 
								'" . str_replace("'", "\'", $mst_tokopedia_keterangan) . "',
								'" . str_replace("'", "\'", $mst_tokopedia_notasi) . "',
								'$mst_tokopedia_harga',
								'$mst_tokopedia_admin', 
								'$mst_tokopedia_poin', 
								'$mst_tokopedia_urutan')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_hapus($mst_tokopedia_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_tokopedia/hapus');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_mst_tokopedia where mst_tokopedia_kode='$mst_tokopedia_kode'");
    }

    function aksi_tidak_aktif($mst_tokopedia_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_tokopedia/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_tokopedia set
                                        mst_tokopedia_status='1'
                                        where  mst_tokopedia_kode='$mst_tokopedia_kode'");
    }

    function aksi_aktif($mst_tokopedia_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_tokopedia/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_tokopedia set
                                        mst_tokopedia_status='0'
                                        where  mst_tokopedia_kode='$mst_tokopedia_kode'");
    }
}
