<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Kategori_produk extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_produk');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Kategori Produk';

        $this->template->load('includes/header', 'kategori/view_kategori_produk', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url_ktg_produk_icon = 'http://141.11.241.178/arifahpulsa/admin/assets/upload/data-kategori/';

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_ktg_produk 
                                          ORDER BY ktg_produk_urutan ASC ");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>NAMA</th>
                        <th>ICON</th>
                        <th>URUTAN</th>
                        <th>KETERANGAN</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            if ($row->ktg_produk_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->ktg_produk_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->ktg_produk_kode . "')>SET TIDAK AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->ktg_produk_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->ktg_produk_kode . "')>SET AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }


            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_ktg_produk_status'>$status</td>";
            echo            "<td id='tbl_ktg_produk_kode'>$row->ktg_produk_kode</td>";
            echo            "<td id='tbl_ktg_produk_nama'>$row->ktg_produk_nama</td>";
            echo            "<td id='tbl_ktg_produk_icon'><img src='$url_ktg_produk_icon" . "$row->ktg_produk_icon' class='rounded' alt='$row->ktg_produk_icon' style='width:70;height:70px;text-align:center'></td>";
            echo            "<td id='tbl_ktg_produk_urutan'>$row->ktg_produk_urutan</td> ";
            echo            "<td id='tbl_ktg_produk_keterangan'>$row->ktg_produk_keterangan</td>";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
              
                $(document).ready(function () {
                    var table = $('#example1').DataTable({
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $ktg_produk_kode = $this->input->post("ktg_produk_kode");
        $ktg_produk_nama = $this->input->post("ktg_produk_nama");
        $ktg_produk_urutan = $this->input->post("ktg_produk_urutan");
        $ktg_produk_keterangan = $this->input->post("ktg_produk_keterangan");
        $ktg_produk_notasi = $this->input->post("ktg_produk_notasi");

        //UPLOAD GAMBAR
        $config['upload_path'] = 'assets/upload/data-kategori/';
        $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
        $config['remove_spaces'] = TRUE;
        $config['overwrite'] = TRUE;
        $config['max_size'] = '20000';
        $config['file_name'] = 'KTG-' . $ktg_produk_kode . "-" . rand(0, 999);

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $this->upload->data();
        if ($this->upload->do_upload('ktg_produk_icon')) {
            $img_foto = $this->upload->data();
            $ktg_produk_icon = $img_foto['file_name'];
            $db_arifahpulsa_api->query("UPDATE tbl_ktg_produk set
                                        ktg_produk_nama='" . str_replace("'", "\'", $ktg_produk_nama) . "',
                                        ktg_produk_icon='$ktg_produk_icon',
                                        ktg_produk_urutan='$ktg_produk_urutan',
                                        ktg_produk_keterangan='" . str_replace("'", "\'", $ktg_produk_keterangan) . "'
                                        where  ktg_produk_kode='$ktg_produk_kode'");
        } else {
            $db_arifahpulsa_api->query("UPDATE tbl_ktg_produk set
                                        ktg_produk_nama='" . str_replace("'", "\'", $ktg_produk_nama) . "',
                                        ktg_produk_urutan='$ktg_produk_urutan',
                                        ktg_produk_keterangan='" . str_replace("'", "\'", $ktg_produk_keterangan) . "'
                                        where ktg_produk_kode='$ktg_produk_kode'");
        }

        $data['edit_status'] = '0';
        echo json_encode($data);
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $ktg_produk_kode = $this->input->post("ktg_produk_kode");
        $ktg_produk_nama = $this->input->post("ktg_produk_nama");
        $ktg_produk_urutan = $this->input->post("ktg_produk_urutan");
        $ktg_produk_keterangan = $this->input->post("ktg_produk_keterangan");

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_ktg_produk where ktg_produk_kode='$ktg_produk_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {

            //UPLOAD GAMBAR
            $config['upload_path'] = 'assets/upload/data-kategori/';
            $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
            $config['remove_spaces'] = TRUE;
            $config['overwrite'] = TRUE;
            $config['max_size'] = '20000';
            $config['file_name'] = 'KTG-' . $ktg_produk_kode;

            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->data();
            if ($this->upload->do_upload('ktg_produk_icon')) {
                $img_foto = $this->upload->data();
                $ktg_produk_icon = $img_foto['file_name'];
            } else {
                $ktg_produk_icon = "no_image.png";
            }

            $db_arifahpulsa_api->query("insert into tbl_ktg_produk (
                                ktg_produk_kode,
								ktg_produk_nama, 
                                ktg_produk_icon, 
                                ktg_produk_urutan,
								ktg_produk_keterangan) values (
                                '$ktg_produk_kode', 
							    '" . str_replace("'", "\'", $ktg_produk_nama) . "',
								'$ktg_produk_icon', 
								'$ktg_produk_urutan', 
								'" . str_replace("'", "\'", $ktg_produk_keterangan) . "')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_hapus($ktg_produk_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_ktg_produk where ktg_produk_kode='$ktg_produk_kode'");
    }

    function aksi_tidak_aktif($ktg_produk_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_ktg_produk set
                                        ktg_produk_status='1'
                                        where  ktg_produk_kode='$ktg_produk_kode'");
    }

    function aksi_aktif($ktg_produk_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_ktg_produk set
                                        ktg_produk_status='0'
                                        where  ktg_produk_kode='$ktg_produk_kode'");
    }
}
