<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Cron_prabayar extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Jakarta");
    }

    public function index()
    {
        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url = "https://api.digiflazz.com/v1/price-list";

        $header = array(
            'Content-Type: text/plain',
        );

        $data = array(
            'cmd' => 'prepaid',
            'username' => $this->config->item('digiflazz_api_username'),
            'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . 'pricelist')
        );

        $json = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true)['data'];

        foreach ($response as $data) {
            //DIGIFLAZZ
            $buyer_sku_code = $data['buyer_sku_code'];
            $price = $data['price'];
            $seller_product_status = $data['seller_product_status'];
            $buyer_product_status = $data['buyer_product_status'];

            if ($seller_product_status === true && $buyer_product_status === true) {
                //AKTIF
                $tbl_mst_pulsa[] = array(
                    'mst_pulsa_kode' => $buyer_sku_code,
                    'mst_pulsa_harga' =>  $price,
                    'mst_pulsa_status' =>  '0'
                );

                $tbl_mst_paket_data[] = array(
                    'mst_paket_data_kode' => $buyer_sku_code,
                    'mst_paket_data_harga' =>  $price,
                    'mst_paket_data_status' =>  '0'
                );

                $tbl_mst_paket_nelfon[] = array(
                    'mst_paket_nelfon_kode' => $buyer_sku_code,
                    'mst_paket_nelfon_harga' =>  $price,
                    'mst_paket_nelfon_status' =>  '0'
                );

                $tbl_mst_paket_sms[] = array(
                    'mst_paket_sms_kode' => $buyer_sku_code,
                    'mst_paket_sms_harga' =>  $price,
                    'mst_paket_sms_status' =>  '0'
                );

                $tbl_mst_token_pln[] = array(
                    'mst_token_pln_kode' => $buyer_sku_code,
                    'mst_token_pln_harga' =>  $price,
                    'mst_token_pln_status' =>  '0'
                );

                $tbl_mst_masa_aktif[] = array(
                    'mst_masa_aktif_kode' => $buyer_sku_code,
                    'mst_masa_aktif_harga' =>  $price,
                    'mst_masa_aktif_status' =>  '0'
                );

                $tbl_mst_pulsa_transfer[] = array(
                    'mst_pulsa_transfer_kode' => $buyer_sku_code,
                    'mst_pulsa_transfer_harga' =>  $price,
                    'mst_pulsa_transfer_status' =>  '0'
                );

                $tbl_mst_game[] = array(
                    'mst_game_kode' => $buyer_sku_code,
                    'mst_game_harga' =>  $price,
                    'mst_game_status' =>  '0'
                );

                $tbl_mst_gopay[] = array(
                    'mst_gopay_kode' => $buyer_sku_code,
                    'mst_gopay_harga' =>  $price,
                    'mst_gopay_status' =>  '0'
                );

                $tbl_mst_ovo[] = array(
                    'mst_ovo_kode' => $buyer_sku_code,
                    'mst_ovo_harga' =>  $price,
                    'mst_ovo_status' =>  '0'
                );

                $tbl_mst_linkaja[] = array(
                    'mst_linkaja_kode' => $buyer_sku_code,
                    'mst_linkaja_harga' =>  $price,
                    'mst_linkaja_status' =>  '0'
                );

                $tbl_mst_maxim[] = array(
                    'mst_maxim_kode' => $buyer_sku_code,
                    'mst_maxim_harga' =>  $price,
                    'mst_maxim_status' =>  '0'
                );

                $tbl_mst_dana[] = array(
                    'mst_dana_kode' => $buyer_sku_code,
                    'mst_dana_harga' =>  $price,
                    'mst_dana_status' =>  '0'
                );

                $tbl_mst_shopeepay[] = array(
                    'mst_shopeepay_kode' => $buyer_sku_code,
                    'mst_shopeepay_harga' =>  $price,
                    'mst_shopeepay_status' =>  '0'
                );

                $tbl_mst_doku[] = array(
                    'mst_doku_kode' => $buyer_sku_code,
                    'mst_doku_harga' =>  $price,
                    'mst_doku_status' =>  '0'
                );

                $tbl_mst_grab[] = array(
                    'mst_grab_kode' => $buyer_sku_code,
                    'mst_grab_harga' =>  $price,
                    'mst_grab_status' =>  '0'
                );

                $tbl_mst_sakuku[] = array(
                    'mst_sakuku_kode' => $buyer_sku_code,
                    'mst_sakuku_harga' =>  $price,
                    'mst_sakuku_status' =>  '0'
                );

                $tbl_mst_isaku[] = array(
                    'mst_isaku_kode' => $buyer_sku_code,
                    'mst_isaku_harga' =>  $price,
                    'mst_isaku_status' =>  '0'
                );

                $tbl_mst_gojek_driver[] = array(
                    'mst_gojek_driver_kode' => $buyer_sku_code,
                    'mst_gojek_driver_harga' =>  $price,
                    'mst_gojek_driver_status' =>  '0'
                );

                $tbl_mst_maxim_driver[] = array(
                    'mst_maxim_driver_kode' => $buyer_sku_code,
                    'mst_maxim_driver_harga' =>  $price,
                    'mst_maxim_driver_status' =>  '0'
                );

                $tbl_mst_grab_driver[] = array(
                    'mst_grab_driver_kode' => $buyer_sku_code,
                    'mst_grab_driver_harga' =>  $price,
                    'mst_grab_driver_status' =>  '0'
                );

                $tbl_mst_shopee_driver[] = array(
                    'mst_shopee_driver_kode' => $buyer_sku_code,
                    'mst_shopee_driver_harga' =>  $price,
                    'mst_shopee_driver_status' =>  '0'
                );

                $tbl_mst_indomaret[] = array(
                    'mst_indomaret_kode' => $buyer_sku_code,
                    'mst_indomaret_harga' =>  $price,
                    'mst_indomaret_status' =>  '0'
                );

                $tbl_mst_alfamart[] = array(
                    'mst_alfamart_kode' => $buyer_sku_code,
                    'mst_alfamart_harga' =>  $price,
                    'mst_alfamart_status' =>  '0'
                );

                $tbl_mst_tokopedia[] = array(
                    'mst_tokopedia_kode' => $buyer_sku_code,
                    'mst_tokopedia_harga' =>  $price,
                    'mst_tokopedia_status' =>  '0'
                );

                $tbl_mst_materai[] = array(
                    'mst_materai_kode' => $buyer_sku_code,
                    'mst_materai_harga' =>  $price,
                    'mst_materai_status' =>  '0'
                );

                $tbl_mst_traveloka[] = array(
                    'mst_traveloka_kode' => $buyer_sku_code,
                    'mst_traveloka_harga' =>  $price,
                    'mst_traveloka_status' =>  '0'
                );

                $tbl_mst_mtix[] = array(
                    'mst_mtix_kode' => $buyer_sku_code,
                    'mst_mtix_harga' =>  $price,
                    'mst_mtix_status' =>  '0'
                );

                $tbl_mst_tixid[] = array(
                    'mst_tixid_kode' => $buyer_sku_code,
                    'mst_tixid_harga' =>  $price,
                    'mst_tixid_status' =>  '0'
                );

                $tbl_mst_spotify[] = array(
                    'mst_spotify_kode' => $buyer_sku_code,
                    'mst_spotify_harga' =>  $price,
                    'mst_spotify_status' =>  '0'
                );

                $tbl_mst_googleplay[] = array(
                    'mst_googleplay_kode' => $buyer_sku_code,
                    'mst_googleplay_harga' =>  $price,
                    'mst_googleplay_status' =>  '0'
                );

                $tbl_mst_vidio[] = array(
                    'mst_vidio_kode' => $buyer_sku_code,
                    'mst_vidio_harga' =>  $price,
                    'mst_vidio_status' =>  '0'
                );

                $tbl_mst_unipin[] = array(
                    'mst_unipin_kode' => $buyer_sku_code,
                    'mst_unipin_harga' =>  $price,
                    'mst_unipin_status' =>  '0'
                );

                $tbl_mst_wifiid[] = array(
                    'mst_wifiid_kode' => $buyer_sku_code,
                    'mst_wifiid_harga' =>  $price,
                    'mst_wifiid_status' =>  '0'
                );

                $tbl_mst_emoney[] = array(
                    'mst_emoney_kode' => $buyer_sku_code,
                    'mst_emoney_harga' =>  $price,
                    'mst_emoney_status' =>  '0'
                );

                $tbl_mst_tapcash[] = array(
                    'mst_tapcash_kode' => $buyer_sku_code,
                    'mst_tapcash_harga' =>  $price,
                    'mst_tapcash_status' =>  '0'
                );

                $tbl_mst_brizzi[] = array(
                    'mst_brizzi_kode' => $buyer_sku_code,
                    'mst_brizzi_harga' =>  $price,
                    'mst_brizzi_status' =>  '0'
                );
            } else {
                //TIDAK AKTIF
                $tbl_mst_pulsa[] = array(
                    'mst_pulsa_kode' => $buyer_sku_code,
                    'mst_pulsa_harga' =>  $price,
                    'mst_pulsa_status' =>  '1'
                );

                $tbl_mst_paket_data[] = array(
                    'mst_paket_data_kode' => $buyer_sku_code,
                    'mst_paket_data_harga' =>  $price,
                    'mst_paket_data_status' =>  '1'
                );

                $tbl_mst_paket_nelfon[] = array(
                    'mst_paket_nelfon_kode' => $buyer_sku_code,
                    'mst_paket_nelfon_harga' =>  $price,
                    'mst_paket_nelfon_status' =>  '1'
                );

                $tbl_mst_paket_sms[] = array(
                    'mst_paket_sms_kode' => $buyer_sku_code,
                    'mst_paket_sms_harga' =>  $price,
                    'mst_paket_sms_status' =>  '1'
                );

                $tbl_mst_token_pln[] = array(
                    'mst_token_pln_kode' => $buyer_sku_code,
                    'mst_token_pln_harga' =>  $price,
                    'mst_token_pln_status' =>  '1'
                );

                $tbl_mst_masa_aktif[] = array(
                    'mst_masa_aktif_kode' => $buyer_sku_code,
                    'mst_masa_aktif_harga' =>  $price,
                    'mst_masa_aktif_status' =>  '1'
                );

                $tbl_mst_pulsa_transfer[] = array(
                    'mst_pulsa_transfer_kode' => $buyer_sku_code,
                    'mst_pulsa_transfer_harga' =>  $price,
                    'mst_pulsa_transfer_status' =>  '1'
                );

                $tbl_mst_game[] = array(
                    'mst_game_kode' => $buyer_sku_code,
                    'mst_game_harga' =>  $price,
                    'mst_game_status' =>  '1'
                );

                $tbl_mst_gopay[] = array(
                    'mst_gopay_kode' => $buyer_sku_code,
                    'mst_gopay_harga' =>  $price,
                    'mst_gopay_status' =>  '1'
                );

                $tbl_mst_ovo[] = array(
                    'mst_ovo_kode' => $buyer_sku_code,
                    'mst_ovo_harga' =>  $price,
                    'mst_ovo_status' =>  '1'
                );

                $tbl_mst_linkaja[] = array(
                    'mst_linkaja_kode' => $buyer_sku_code,
                    'mst_linkaja_harga' =>  $price,
                    'mst_linkaja_status' =>  '1'
                );

                $tbl_mst_maxim[] = array(
                    'mst_maxim_kode' => $buyer_sku_code,
                    'mst_maxim_harga' =>  $price,
                    'mst_maxim_status' =>  '1'
                );

                $tbl_mst_dana[] = array(
                    'mst_dana_kode' => $buyer_sku_code,
                    'mst_dana_harga' =>  $price,
                    'mst_dana_status' =>  '1'
                );

                $tbl_mst_shopeepay[] = array(
                    'mst_shopeepay_kode' => $buyer_sku_code,
                    'mst_shopeepay_harga' =>  $price,
                    'mst_shopeepay_status' =>  '1'
                );

                $tbl_mst_doku[] = array(
                    'mst_doku_kode' => $buyer_sku_code,
                    'mst_doku_harga' =>  $price,
                    'mst_doku_status' =>  '1'
                );

                $tbl_mst_grab[] = array(
                    'mst_grab_kode' => $buyer_sku_code,
                    'mst_grab_harga' =>  $price,
                    'mst_grab_status' =>  '1'
                );

                $tbl_mst_sakuku[] = array(
                    'mst_sakuku_kode' => $buyer_sku_code,
                    'mst_sakuku_harga' =>  $price,
                    'mst_sakuku_status' =>  '1'
                );

                $tbl_mst_isaku[] = array(
                    'mst_isaku_kode' => $buyer_sku_code,
                    'mst_isaku_harga' =>  $price,
                    'mst_isaku_status' =>  '1'
                );

                $tbl_mst_gojek_driver[] = array(
                    'mst_gojek_driver_kode' => $buyer_sku_code,
                    'mst_gojek_driver_harga' =>  $price,
                    'mst_gojek_driver_status' =>  '1'
                );

                $tbl_mst_maxim_driver[] = array(
                    'mst_maxim_driver_kode' => $buyer_sku_code,
                    'mst_maxim_driver_harga' =>  $price,
                    'mst_maxim_driver_status' =>  '1'
                );

                $tbl_mst_grab_driver[] = array(
                    'mst_grab_driver_kode' => $buyer_sku_code,
                    'mst_grab_driver_harga' =>  $price,
                    'mst_grab_driver_status' =>  '1'
                );

                $tbl_mst_shopee_driver[] = array(
                    'mst_shopee_driver_kode' => $buyer_sku_code,
                    'mst_shopee_driver_harga' =>  $price,
                    'mst_shopee_driver_status' =>  '1'
                );

                $tbl_mst_indomaret[] = array(
                    'mst_indomaret_kode' => $buyer_sku_code,
                    'mst_indomaret_harga' =>  $price,
                    'mst_indomaret_status' =>  '1'
                );

                $tbl_mst_alfamart[] = array(
                    'mst_alfamart_kode' => $buyer_sku_code,
                    'mst_alfamart_harga' =>  $price,
                    'mst_alfamart_status' =>  '1'
                );

                $tbl_mst_tokopedia[] = array(
                    'mst_tokopedia_kode' => $buyer_sku_code,
                    'mst_tokopedia_harga' =>  $price,
                    'mst_tokopedia_status' =>  '1'
                );

                $tbl_mst_materai[] = array(
                    'mst_materai_kode' => $buyer_sku_code,
                    'mst_materai_harga' =>  $price,
                    'mst_materai_status' =>  '1'
                );

                $tbl_mst_traveloka[] = array(
                    'mst_traveloka_kode' => $buyer_sku_code,
                    'mst_traveloka_harga' =>  $price,
                    'mst_traveloka_status' =>  '1'
                );

                $tbl_mst_mtix[] = array(
                    'mst_mtix_kode' => $buyer_sku_code,
                    'mst_mtix_harga' =>  $price,
                    'mst_mtix_status' =>  '1'
                );

                $tbl_mst_tixid[] = array(
                    'mst_tixid_kode' => $buyer_sku_code,
                    'mst_tixid_harga' =>  $price,
                    'mst_tixid_status' =>  '1'
                );

                $tbl_mst_spotify[] = array(
                    'mst_spotify_kode' => $buyer_sku_code,
                    'mst_spotify_harga' =>  $price,
                    'mst_spotify_status' =>  '1'
                );

                $tbl_mst_googleplay[] = array(
                    'mst_googleplay_kode' => $buyer_sku_code,
                    'mst_googleplay_harga' =>  $price,
                    'mst_googleplay_status' =>  '1'
                );

                $tbl_mst_vidio[] = array(
                    'mst_vidio_kode' => $buyer_sku_code,
                    'mst_vidio_harga' =>  $price,
                    'mst_vidio_status' =>  '1'
                );

                $tbl_mst_unipin[] = array(
                    'mst_unipin_kode' => $buyer_sku_code,
                    'mst_unipin_harga' =>  $price,
                    'mst_unipin_status' =>  '1'
                );

                $tbl_mst_wifiid[] = array(
                    'mst_wifiid_kode' => $buyer_sku_code,
                    'mst_wifiid_harga' =>  $price,
                    'mst_wifiid_status' =>  '1'
                );

                $tbl_mst_emoney[] = array(
                    'mst_emoney_kode' => $buyer_sku_code,
                    'mst_emoney_harga' =>  $price,
                    'mst_emoney_status' =>  '1'
                );

                $tbl_mst_tapcash[] = array(
                    'mst_tapcash_kode' => $buyer_sku_code,
                    'mst_tapcash_harga' =>  $price,
                    'mst_tapcash_status' =>  '1'
                );

                $tbl_mst_brizzi[] = array(
                    'mst_brizzi_kode' => $buyer_sku_code,
                    'mst_brizzi_harga' =>  $price,
                    'mst_brizzi_status' =>  '1'
                );
            }
        }

        //UPDATE
        $db_arifahpulsa_api->update_batch('tbl_mst_pulsa', $tbl_mst_pulsa, 'mst_pulsa_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_paket_data', $tbl_mst_paket_data, 'mst_paket_data_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_paket_nelfon', $tbl_mst_paket_nelfon, 'mst_paket_nelfon_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_paket_sms', $tbl_mst_paket_sms, 'mst_paket_sms_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_token_pln', $tbl_mst_token_pln, 'mst_token_pln_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_masa_aktif', $tbl_mst_masa_aktif, 'mst_masa_aktif_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_pulsa_transfer', $tbl_mst_pulsa_transfer, 'mst_pulsa_transfer_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_game', $tbl_mst_game, 'mst_game_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_gopay', $tbl_mst_gopay, 'mst_gopay_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_ovo', $tbl_mst_ovo, 'mst_ovo_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_linkaja', $tbl_mst_linkaja, 'mst_linkaja_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_maxim', $tbl_mst_maxim, 'mst_maxim_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_dana', $tbl_mst_dana, 'mst_dana_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_shopeepay', $tbl_mst_shopeepay, 'mst_shopeepay_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_doku', $tbl_mst_doku, 'mst_doku_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_grab', $tbl_mst_grab, 'mst_grab_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_sakuku', $tbl_mst_sakuku, 'mst_sakuku_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_isaku', $tbl_mst_isaku, 'mst_isaku_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_gojek_driver', $tbl_mst_gojek_driver, 'mst_gojek_driver_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_maxim_driver', $tbl_mst_maxim_driver, 'mst_maxim_driver_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_grab_driver', $tbl_mst_grab_driver, 'mst_grab_driver_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_shopee_driver', $tbl_mst_shopee_driver, 'mst_shopee_driver_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_indomaret', $tbl_mst_indomaret, 'mst_indomaret_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_alfamart', $tbl_mst_alfamart, 'mst_alfamart_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_tokopedia', $tbl_mst_tokopedia, 'mst_tokopedia_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_materai', $tbl_mst_materai, 'mst_materai_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_traveloka', $tbl_mst_traveloka, 'mst_traveloka_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_mtix', $tbl_mst_mtix, 'mst_mtix_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_tixid', $tbl_mst_tixid, 'mst_tixid_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_spotify', $tbl_mst_spotify, 'mst_spotify_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_googleplay', $tbl_mst_googleplay, 'mst_googleplay_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_vidio', $tbl_mst_vidio, 'mst_vidio_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_unipin', $tbl_mst_unipin, 'mst_unipin_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_wifiid', $tbl_mst_wifiid, 'mst_wifiid_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_emoney', $tbl_mst_emoney, 'mst_emoney_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_tapcash', $tbl_mst_tapcash, 'mst_tapcash_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_brizzi', $tbl_mst_brizzi, 'mst_brizzi_kode');


        //LOG
        $log_file = APPPATH . 'logs/prabayar.txt';
        $log_msg = date('Y-m-d H:i:s') . " - Cron prabayar dijalankan\n";
        file_put_contents($log_file, '');
        file_put_contents($log_file, $log_msg, FILE_APPEND);
    }
}
