<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Cron_notifikasi extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Jakarta");
    }

    public function index()
    {
        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        //PANGGI SEMUA USER
        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user")->result_array();
        $jumlah = round(count($query) / 1000);

        //ISI NOTIFIKASI
        $notifikasi = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_notifikasi order by rand() limit 1")->result_array();
        foreach ($notifikasi as $row) {
            $mst_notifikasi_judul = $row['mst_notifikasi_judul'];
            $mst_notifikasi_isi = $row['mst_notifikasi_isi'];
        }

        $this->load->helper("file");
        delete_files('./assets/upload/data-notif/', TRUE);

        for ($x = 0; $x <= $jumlah; $x++) {
            $a = $x + 1;
            $from = ($x * 1000);
            $to = ($a * 1000);

            $sql = $db_arifahpulsa_api->query("SELECT mst_user_firebase FROM tbl_mst_user
                                   group by mst_user_firebase limit 1000 offset $from")->result_array();
            foreach ($sql as $row) {
                $mst_user_firebase[] = $row['mst_user_firebase'];
            }
            file_put_contents('assets/upload/data-notif/' . $x . '.txt',  json_encode($mst_user_firebase, TRUE));


            $a = json_decode(file_get_contents('assets/upload/data-notif/' . $x . '.txt'));

            $fcmUrl = 'https://fcm.googleapis.com/fcm/send';

            $notification = array(
                'type' => 1,
                'title' => $mst_notifikasi_judul,
                'body' => $mst_notifikasi_isi,
                'click_action' => 'main_activity',
                'tipe' => 'callback',
                'sound' => 'default',
                'icon'  => 'ic_notification',
            );

            $fcmNotification = [
                'registration_ids' => $mst_user_firebase,
                //'to'        => $mst_user_firebase,
                'data' => $notification,
                'notification' => $notification,
                'priority' => 'high',
                'apns-priority' => '5'
            ];

            $headers = [
                'Authorization: key=' . $this->config->item('firebase_key'),
                'Content-Type: application/json'
            ];


            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $fcmUrl);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmNotification));
            $result = curl_exec($ch);
            curl_close($ch);

            unset($mst_user_firebase);
        }


        //LOG
        $log_file = APPPATH . 'logs/notifikasi.txt';
        $log_msg = date('Y-m-d H:i:s') . " - Cron notifikasi dijalankan : " . $mst_notifikasi_isi . "\n";
        file_put_contents($log_file, '');
        file_put_contents($log_file, $log_msg, FILE_APPEND);
    }
}
