<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Produk extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('produk');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Produk';

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);
        $data['kategori'] = $db_arifahpulsa_api->query("SELECT * from tbl_ktg_produk");

        $this->template->load('includes/header', 'view_produk', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url_mst_produk_foto = 'http://141.11.241.178/arifahpulsa/admin/assets/upload/data-produk/';

        $query = $db_arifahpulsa_api->query("SELECT mst_produk_kode,mst_produk_kategori_kode,ktg_produk_nama,
                                    mst_produk_nama,mst_produk_satuan,
                                    mst_produk_harga,mst_produk_diskon,
                                    mst_produk_deskripsi,mst_produk_foto,
                                    mst_produk_nama_penjual,mst_produk_nohp_penjual,
                                    mst_produk_rekomendasi,mst_produk_status
                                    FROM tbl_mst_produk,tbl_ktg_produk
                                    WHERE mst_produk_kategori_kode=ktg_produk_kode");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>NAMA KATEGORI</th>
                        <th>REKOMENDASI</th>
                        <th>KODE KATEGORI</th>
                        <th>NAMA KATEGORI</th>
                        <th>FOTO</th>
                        <th>NAMA</th>
                        <th>SATUAN</th>
                        <th>HARGA</th>
                        <th>DISKON</th>
                        <th>NAMA PENJUAL</th>
                        <th>NOHP PENJUAL</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            //STATUS
            if ($row->mst_produk_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_rekomendasi('" . $row->mst_produk_kode . "')>REKOMENDASIKAN</a>
                            <a class='dropdown-item' onclick=aksi_tidak_rekomendasi('" . $row->mst_produk_kode . "')>TIDAK DI REKOMENDASIKAN</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->mst_produk_kode . "')>SET TIDAK AKTIF</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_produk_kode . "')>HAPUS</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->mst_produk_kode . "')>SET AKTIF</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_produk_kode . "')>HAPUS</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }

            //FOTO
            $mst_produk_foto = "<img src='$url_mst_produk_foto" . "$row->mst_produk_foto' class='rounded' alt='$row->mst_produk_foto' style='width:70;height:70px;text-align:center'>";

            //DESKRIPSI
            if (strlen($row->mst_produk_deskripsi) > 10) {
                $words = explode(' ', $row->mst_produk_deskripsi);
                $limitedWords = array_slice($words, 0, 15);
                $mst_produk_deskripsi = implode(' ', $limitedWords);
            } else {
                $mst_produk_deskripsi = $row->mst_produk_deskripsi;
            }

            if ($row->mst_produk_rekomendasi == '0') {
                $mst_produk_rekomendasi = "<div class='btn btn-danger'>TIDAK DI REKOMENDASI</div>";
            } else {
                $mst_produk_rekomendasi = "<div class='btn btn-success'>DI REKOMENDASI</div>";
            }

            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_mst_produk_status'>$status</td>";
            echo            "<td id='tbl_mst_produk_kode'>$row->mst_produk_kode</td>";
            echo            "<td id='tbl_ktg_produk_nama'>$row->ktg_produk_nama</td>";
            echo            "<td id='tbl_mst_produk_rekomendasi'>$mst_produk_rekomendasi</td>";
            echo            "<td id='tbl_mst_produk_kategori_kode'>$row->mst_produk_kategori_kode</td>";
            echo            "<td id='tbl_ktg_produk_nama'>$row->ktg_produk_nama</td>";
            echo            "<td id='tbl_mst_produk_foto'>$mst_produk_foto</td>";
            echo            "<td id='tbl_mst_produk_nama'>$row->mst_produk_nama</td> ";
            echo            "<td id='tbl_mst_produk_satuan'>$row->mst_produk_satuan</td>";
            echo            "<td id='tbl_mst_produk_harga'>$row->mst_produk_harga</td>";
            echo            "<td id='tbl_mst_produk_diskon'>$row->mst_produk_diskon</td>";
            echo            "<td id='tbl_mst_produk_nama_penjual'>$row->mst_produk_nama_penjual</td>";
            echo            "<td id='tbl_mst_produk_nohp_penjual'>$row->mst_produk_nohp_penjual</td>";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
                $(document).ready(function () {
                    var groupColumn = 4;
                    var table = $('#example1').DataTable({
                        columnDefs: [{ visible: false, targets: groupColumn }],
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                        drawCallback: function (settings) {
                            var api = this.api();
                            var rows = api.rows({ page: 'current' }).nodes();
                            var last = null;
                
                            api
                                .column(groupColumn, { page: 'current' })
                                .data()
                                .each(function (group, i) {
                                    if (last !== group) {
                                        $(rows)
                                            .eq(i)
                                            .before('<tr ";
        echo                                'class="group"><th colspan="15"><div class="btn btn-success">';
        echo                                "' + group + ";
        echo                                "'</div></th></tr>');
                
                                      last = group;
                                    }
                                });
                        },
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_produk_kode = $this->input->post("mst_produk_kode");
        $mst_produk_kategori_kode = $this->input->post("mst_produk_kategori_kode");
        $mst_produk_nama = $this->input->post("mst_produk_nama");
        $mst_produk_satuan = $this->input->post("mst_produk_satuan");
        $mst_produk_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_produk_harga"));
        $mst_produk_diskon = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_produk_diskon"));
        $mst_produk_deskripsi = $this->input->post("mst_produk_deskripsi");
        $mst_produk_nama_penjual = $this->input->post("mst_produk_nama_penjual");
        $mst_produk_nohp_penjual = $this->input->post("mst_produk_nohp_penjual");


        //UPLOAD GAMBAR
        $config['upload_path'] = 'assets/upload/data-produk/';
        $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
        $config['remove_spaces'] = TRUE;
        $config['overwrite'] = TRUE;
        $config['max_size'] = '20000';
        $config['file_name'] = 'PRD-' . $mst_produk_kode . "-" . rand(0, 999);

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $this->upload->data();
        if ($this->upload->do_upload('mst_produk_foto')) {
            $img_foto = $this->upload->data();
            $mst_produk_foto = $img_foto['file_name'];

            $db_arifahpulsa_api->query("UPDATE tbl_mst_produk set
                                        mst_produk_kategori_kode='$mst_produk_kategori_kode',
                                        mst_produk_nama='" . str_replace("'", "\'", $mst_produk_nama) . "',
                                        mst_produk_satuan='$mst_produk_satuan',
                                        mst_produk_harga='$mst_produk_harga',
                                        mst_produk_diskon='$mst_produk_diskon',
                                        mst_produk_deskripsi='" . str_replace(" '", "\'", $mst_produk_deskripsi) . "',
                                        mst_produk_foto='$mst_produk_foto',
                                        mst_produk_nama_penjual='$mst_produk_nama_penjual',
                                        mst_produk_nohp_penjual='$mst_produk_nohp_penjual'
                                        where mst_produk_kode='$mst_produk_kode'");
        } else {
            $db_arifahpulsa_api->query("UPDATE tbl_mst_produk set
                                     mst_produk_kategori_kode='$mst_produk_kategori_kode',
                                        mst_produk_nama='" . str_replace("'", "\'", $mst_produk_nama) . "',
                                        mst_produk_satuan='$mst_produk_satuan',
                                        mst_produk_harga='$mst_produk_harga',
                                        mst_produk_diskon='$mst_produk_diskon',
                                        mst_produk_deskripsi='" . str_replace(" '", "\'", $mst_produk_deskripsi) . "',
                                        mst_produk_nama_penjual='$mst_produk_nama_penjual',
                                        mst_produk_nohp_penjual='$mst_produk_nohp_penjual'
                                        where mst_produk_kode='$mst_produk_kode'");
        }

        $data['edit_status'] = '0';
        echo json_encode($data);
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_produk_kode = $this->input->post("mst_produk_kode");
        $mst_produk_kategori_kode = $this->input->post("mst_produk_kategori_kode");
        $mst_produk_nama = $this->input->post("mst_produk_nama");
        $mst_produk_satuan = $this->input->post("mst_produk_satuan");
        $mst_produk_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_produk_harga"));
        $mst_produk_diskon = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_produk_diskon"));
        $mst_produk_deskripsi = $this->input->post("mst_produk_deskripsi");
        $mst_produk_nama_penjual = $this->input->post("mst_produk_nama_penjual");
        $mst_produk_nohp_penjual = $this->input->post("mst_produk_nohp_penjual");
        $mst_produk_rekomendasi = "0";
        $mst_produk_status = "0";

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_mst_produk where mst_produk_kode='$mst_produk_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {

            //UPLOAD GAMBAR
            $config['upload_path'] = 'assets/upload/data-produk/';
            $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
            $config['remove_spaces'] = TRUE;
            $config['overwrite'] = TRUE;
            $config['max_size'] = '20000';
            $config['file_name'] = 'PRD-' . $mst_produk_kode . "-" . rand(111, 222);

            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->data();
            if ($this->upload->do_upload('mst_produk_foto')) {
                $img_foto = $this->upload->data();
                $mst_produk_foto = $img_foto['file_name'];
            } else {
                $mst_produk_foto = "no_image.png";
            }

            $db_arifahpulsa_api->query("insert into tbl_mst_produk (
                                mst_produk_kode,
                                mst_produk_kategori_kode, 
								mst_produk_nama, 
                                mst_produk_satuan, 
                                mst_produk_harga, 
                                mst_produk_diskon, 
                                mst_produk_deskripsi, 
                                mst_produk_foto,
                                mst_produk_nama_penjual,
								mst_produk_nohp_penjual,
                                mst_produk_rekomendasi,
                                mst_produk_status) values (
                                '$mst_produk_kode', 
                                '$mst_produk_kategori_kode', 
							    '" . str_replace("'", "\'", $mst_produk_nama) . "',
                                '$mst_produk_satuan', 
                                '$mst_produk_harga', 
                                '$mst_produk_diskon', 
                                '" . str_replace("'", "\'", $mst_produk_deskripsi) . "',
                                '$mst_produk_foto', 
                                '" . str_replace("'", "\'", $mst_produk_nama_penjual) . "',
                                '$mst_produk_nohp_penjual', 
								'$mst_produk_rekomendasi',
								'$mst_produk_status')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_rekomendasi($mst_produk_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);


        $db_arifahpulsa_api->query("UPDATE tbl_mst_produk set
                            mst_produk_rekomendasi='1'
                            where  mst_produk_kode='$mst_produk_kode'");
    }

    function aksi_tidak_rekomendasi($mst_produk_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);


        $db_arifahpulsa_api->query("UPDATE tbl_mst_produk set
                            mst_produk_rekomendasi='0'
                            where  mst_produk_kode='$mst_produk_kode'");
    }

    function aksi_aktif($mst_produk_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_produk set
                            mst_produk_status='0'
                            where  mst_produk_kode='$mst_produk_kode'");
    }

    function aksi_tidak_aktif($mst_produk_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_produk set
                            mst_produk_status='1'
                            where  mst_produk_kode='$mst_produk_kode'");
    }

    function aksi_hapus($mst_produk_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('produk');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_mst_produk where mst_produk_kode='$mst_produk_kode'");
    }
}
