<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Notifikasi extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        return true;
    }


    function index()
    {
        date_default_timezone_set("Asia/Jakarta");
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('notifikasi');

        $this->load->helper("file");
        delete_files('./assets/upload/data-notif/', TRUE);

        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Notifikasi';

        $this->template->load('includes/header', 'view_notifikasi', $data);
    }


    public function custom()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('notifikasi');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $txt_menu = $this->input->post("txt_menu");
        $txt_link = $this->input->post("txt_link");
        $txt_judul = $this->input->post("txt_judul");
        $txt_isi = $this->input->post("txt_isi");

        if ($txt_menu == "webview") {
            $clickaction = "webview_activity";
        } else {
            $clickaction = $txt_menu;
        }

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user")->result_array();
        $jumlah = round(count($query) / 1000);

        $this->load->helper("file");
        delete_files('./assets/upload/data-notif/', TRUE);

        for ($x = 0; $x <= $jumlah; $x++) {
            $a = $x + 1;
            $from = ($x * 1000);
            $to = ($a * 1000);

            $sql = $db_arifahpulsa_api->query("SELECT mst_user_firebase FROM tbl_mst_user
                                   group by mst_user_firebase limit 1000 offset $from")->result_array();
            foreach ($sql as $row) {
                $mst_user_firebase[] = $row['mst_user_firebase'];
            }
            file_put_contents('assets/upload/data-notif/' . $x . '.txt',  json_encode($mst_user_firebase, TRUE));
            unset($mst_user_firebase);

            $generated_user_firebase = json_decode(file_get_contents('assets/upload/data-notif/' . $x . '.txt'));

            $fcmUrl = 'https://fcm.googleapis.com/fcm/send';

            if ($txt_menu == "webview") {
                $notification = array(
                    'type' => 1,
                    'title' => $txt_judul,
                    'body' => $txt_isi,
                    'click_action' =>  $clickaction,
                    'tipe'  =>  $txt_menu,
                    'link'  => $txt_link,
                );
            } else {
                $notification = array(
                    'type' => 1,
                    'title' => $txt_judul,
                    'body' => $txt_isi,
                    'click_action' =>  $clickaction,
                    'tipe'  =>  $txt_menu,
                );
            }

            $fcmNotification = [
                'registration_ids' => $generated_user_firebase,
                'data' => $notification,
                'notification' => $notification,
                'priority' => 'high',
                'apns-priority' => '5'
            ];

            $headers = [
                'Authorization: key=' . $this->config->item('firebase_key'),
                'Content-Type: application/json'
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $fcmUrl);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmNotification));
            $result = curl_exec($ch);
            curl_close($ch);
            unset($mst_user_firebase);
        }
    }
}
