<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Menu extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Menu';

        $this->template->load('includes/header', 'view_menu', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url_mst_menu_icon = 'http://141.11.241.178/arifahpulsa/admin/assets/upload/data-menu/';

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_menu 
                                          GROUP BY mst_menu_kode, mst_menu_grup
                                          ORDER BY mst_menu_grup,mst_menu_urutan ASC ");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>GRUP</th>
                        <th>GRUP</th>
                        <th>NAMA</th>
                        <th>TIPE</th>
                        <th>ICON</th>
                        <th>LINK</th>
                        <th>URUTAN</th>
                        <th>KETERANGAN</th>
                        <th>NOTASI</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            if ($row->mst_menu_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_menu_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->mst_menu_kode . "')>SET TIDAK AKTIF</a>
                            <a class='dropdown-item' onclick=aksi_tidak_tampil('" . $row->mst_menu_kode . "')>SET TIDAK TAMPIL</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else if ($row->mst_menu_status == '2') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_menu_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->mst_menu_kode . "')>SET AKTIF</a>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->mst_menu_kode . "')>SET TIDAK TAMPIL</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-warning'>TIDAK TAMPIL</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_menu_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->mst_menu_kode . "')>SET AKTIF</a>
                            <a class='dropdown-item' onclick=aksi_tidak_tampil('" . $row->mst_menu_kode . "')>SET TIDAK TAMPIL</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }


            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_mst_menu_status'>$status</td>";
            echo            "<td id='tbl_mst_menu_kode'>$row->mst_menu_kode</td>";
            echo            "<td id='tbl_mst_menu_grup'>$row->mst_menu_grup</td>";
            echo            "<td id='tbl_mst_menu_grup'>$row->mst_menu_grup</td>";
            echo            "<td id='tbl_mst_menu_nama'>$row->mst_menu_nama</td>";
            echo            "<td id='tbl_mst_menu_tipe'>$row->mst_menu_tipe</td>";
            echo            "<td id='tbl_mst_menu_icon'><img src='$url_mst_menu_icon" . "$row->mst_menu_icon' class='rounded' alt='$row->mst_menu_icon' style='width:70;height:70px;text-align:center'></td>";
            echo            "<td id='tbl_mst_menu_link'>$row->mst_menu_link</td>";
            echo            "<td id='tbl_mst_menu_urutan'>$row->mst_menu_urutan</td> ";
            echo            "<td id='tbl_mst_menu_keterangan'>$row->mst_menu_keterangan</td>";
            echo            "<td id='tbl_mst_menu_notasi'>$row->mst_menu_notasi</td> ";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
              
                $(document).ready(function () {
                    var groupColumn = 4;
                    var table = $('#example1').DataTable({
                        columnDefs: [{ visible: false, targets: groupColumn }],
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                        drawCallback: function (settings) {
                            var api = this.api();
                            var rows = api.rows({ page: 'current' }).nodes();
                            var last = null;
                
                            api
                                .column(groupColumn, { page: 'current' })
                                .data()
                                .each(function (group, i) {
                                    if (last !== group) {
                                        $(rows)
                                            .eq(i)
                                            .before('<tr ";
        echo                                'class="group"><th colspan="12"><div class="btn btn-success">';
        echo                                "' + group + ";
        echo                                "'</div></th></tr>');
                
                                      last = group;
                                    }
                                });
                        },
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_reload()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url = "https://api.digiflazz.com/v1/price-list";

        $header = array(
            'Content-Type: text/plain',
        );

        $data = array(
            'cmd' => 'pasca',
            'username' => $this->config->item('digiflazz_api_username'),
            'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . 'pricelist')
        );

        $json = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true)['data'];

        foreach ($response as $data) {
            //DIGIFLAZZ
            $buyer_sku_code = $data['buyer_sku_code'];
            $price = $data['price'];
            $seller_product_status = $data['seller_product_status'];
            $buyer_product_status = $data['buyer_product_status'];

            if ($seller_product_status === true && $buyer_product_status === true) {
                if (
                    $buyer_sku_code == 'pln_pascabayar'
                ) {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan PLN dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-012'");
                } else if ($buyer_sku_code == 'bpjs_kesehatan') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan BPSJ Kesehatan dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-009'");
                } else if ($buyer_sku_code == 'gas_negara') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan gas negara dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-017'");
                } else {
                    $hp[] = array(
                        'ktg_hp_kode' => $buyer_sku_code,
                        'ktg_hp_keterangan' =>  'Nomor HP dibutuhkan untuk melakukan transaksi',
                        'ktg_hp_status' =>  '0'
                    );

                    $internet[] = array(
                        'ktg_internet_kode' => $buyer_sku_code,
                        'ktg_internet_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_internet_status' =>  '0'
                    );

                    $multifinance[] = array(
                        'ktg_multifinance_kode' => $buyer_sku_code,
                        'ktg_multifinance_keterangan' =>  'Nomor kontrak dibutuhkan untuk melakukan transaksi',
                        'ktg_multifinance_status' =>  '0'
                    );

                    $pbb[] = array(
                        'ktg_pbb_kode' => $buyer_sku_code,
                        'ktg_pbb_keterangan' =>  'Nomor objek pajak dibutuhkan untuk melakukan transaksi',
                        'ktg_pbb_status' =>  '0'
                    );

                    $pdam[] = array(
                        'ktg_pdam_kode' => $buyer_sku_code,
                        'ktg_pdam_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_pdam_status' =>  '0'
                    );

                    $tv[] = array(
                        'ktg_tv_kode' => $buyer_sku_code,
                        'ktg_tv_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_tv_status' =>  '0'
                    );
                }
            } else {
                if (
                    $buyer_sku_code == 'pln_pascabayar'
                ) {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran listrik pln mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-012'");
                } else if ($buyer_sku_code == 'bpjs_kesehatan') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran BPJS kesehatan mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-009'");
                } else if ($buyer_sku_code == 'gas_negara') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran Gas Negara mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-017'");
                } else {
                    $hp[] = array(
                        'ktg_hp_kode' => $buyer_sku_code,
                        'ktg_hp_keterangan' =>  'Pembayaran tagihan HP mengalami gangguan, silahkan coba secara berkala',
                        'ktg_hp_status' =>  '1'
                    );

                    $internet[] = array(
                        'ktg_internet_kode' => $buyer_sku_code,
                        'ktg_internet_keterangan' => 'Pembayaran tagihan internet mengalami gangguan, silahkan coba secara berkala',
                        'ktg_internet_status' =>  '1'
                    );

                    $multifinance[] = array(
                        'ktg_multifinance_kode' => $buyer_sku_code,
                        'ktg_multifinance_keterangan' =>  'Pembayaran tagihan kredit mengalami gangguan, silahkan coba secara berkala',
                        'ktg_multifinance_status' =>  '1'
                    );

                    $pbb[] = array(
                        'ktg_pbb_kode' => $buyer_sku_code,
                        'ktg_pbb_keterangan' =>  'Pembayaran pajak bumi dan bangunan mengalami gangguan, silahkan coba secara berkala',
                        'ktg_pbb_status' =>  '1'
                    );

                    $pdam[] = array(
                        'ktg_pdam_kode' => $buyer_sku_code,
                        'ktg_pdam_keterangan' =>  'Pembayaran tagihan PDAM mengalami gangguan, silahkan coba secara berkala',
                        'ktg_pdam_status' =>  '1'
                    );

                    $tv[] = array(
                        'ktg_tv_kode' => $buyer_sku_code,
                        'ktg_tv_keterangan' =>  'Pembayaran tagihan TV mengalami gangguan, silahkan coba secara berkala',
                        'ktg_tv_status' =>  '1'
                    );
                }
            }
        }
        //UPDATE
        //UPDATE
        $db_arifahpulsa_api->update_batch('tbl_ktg_hp', $hp, 'ktg_hp_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_internet', $internet, 'ktg_internet_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_multifinance', $multifinance, 'ktg_multifinance_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_pbb', $pbb, 'ktg_pbb_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_pdam', $pdam, 'ktg_pdam_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_tv', $tv, 'ktg_tv_kode');
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_menu_kode = $this->input->post("mst_menu_kode");
        $mst_menu_grup = $this->input->post("mst_menu_grup");
        $mst_menu_nama = $this->input->post("mst_menu_nama");
        $mst_menu_tipe = $this->input->post("mst_menu_tipe");
        $mst_menu_link = $this->input->post("mst_menu_link");
        $mst_menu_urutan = $this->input->post("mst_menu_urutan");
        $mst_menu_keterangan = $this->input->post("mst_menu_keterangan");
        $mst_menu_notasi = $this->input->post("mst_menu_notasi");

        //UPLOAD GAMBAR
        $config['upload_path'] = 'assets/upload/data-menu/';
        $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
        $config['remove_spaces'] = TRUE;
        $config['overwrite'] = TRUE;
        $config['max_size'] = '20000';
        $config['file_name'] = 'KTG-' . $mst_menu_kode;

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $this->upload->data();
        if ($this->upload->do_upload('mst_menu_icon')) {
            $img_foto = $this->upload->data();
            $mst_menu_icon = $img_foto['file_name'];
            $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set
                                        mst_menu_grup='$mst_menu_grup',
                                        mst_menu_nama='" . str_replace("'", "\'", $mst_menu_nama) . "',
                                        mst_menu_tipe='$mst_menu_tipe',
                                        mst_menu_link='$mst_menu_link',
                                        mst_menu_icon='$mst_menu_icon',
                                        mst_menu_urutan='$mst_menu_urutan',
                                        mst_menu_keterangan='" . str_replace("'", "\'", $mst_menu_keterangan) . "',
                                        mst_menu_notasi='" . str_replace("'", "\'", $mst_menu_notasi) . "'
                                        where  mst_menu_kode='$mst_menu_kode'");
        } else {
            $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set
                                       mst_menu_grup='$mst_menu_grup',
                                        mst_menu_nama='" . str_replace("'", "\'", $mst_menu_nama) . "',
                                        mst_menu_tipe='$mst_menu_tipe',
                                        mst_menu_link='$mst_menu_link',
                                        mst_menu_urutan='$mst_menu_urutan',
                                        mst_menu_keterangan='" . str_replace("'", "\'", $mst_menu_keterangan) . "',
                                        mst_menu_notasi='" . str_replace("'", "\'", $mst_menu_notasi) . "'
                                        where mst_menu_kode='$mst_menu_kode'");
        }

        $data['edit_status'] = '0';
        echo json_encode($data);
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_menu_kode = $this->input->post("mst_menu_kode");
        $mst_menu_grup = $this->input->post("mst_menu_grup");
        $mst_menu_nama = $this->input->post("mst_menu_nama");
        $mst_menu_tipe = $this->input->post("mst_menu_tipe");
        $mst_menu_link = $this->input->post("mst_menu_link");
        $mst_menu_urutan = $this->input->post("mst_menu_urutan");
        $mst_menu_keterangan = $this->input->post("mst_menu_keterangan");
        $mst_menu_notasi = $this->input->post("mst_menu_notasi");

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_mst_menu where mst_menu_kode='$mst_menu_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {

            //UPLOAD GAMBAR
            $config['upload_path'] = 'assets/upload/data-menu/';
            $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
            $config['remove_spaces'] = TRUE;
            $config['overwrite'] = TRUE;
            $config['max_size'] = '20000';
            $config['file_name'] = 'KTG-' . $mst_menu_kode;

            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->data();
            if ($this->upload->do_upload('mst_menu_icon')) {
                $img_foto = $this->upload->data();
                $mst_menu_icon = $img_foto['file_name'];
            } else {
                $mst_menu_icon = "no_image.png";
            }

            $db_arifahpulsa_api->query("insert into tbl_mst_menu (
                                mst_menu_kode,
                                mst_menu_grup,
								mst_menu_nama,
                                mst_menu_tipe, 
                                mst_menu_link, 
                                mst_menu_icon, 
                                mst_menu_urutan,
								mst_menu_keterangan, 
								mst_menu_notasi) values (
                                '$mst_menu_kode', 
                                '$mst_menu_grup', 
							    '" . str_replace("'", "\'", $mst_menu_nama) . "',
                                '$mst_menu_tipe', 
                                '$mst_menu_link', 
								'$mst_menu_icon', 
								'$mst_menu_urutan', 
								'" . str_replace("'", "\'", $mst_menu_keterangan) . "',
                                '" . str_replace("'", "\'", $mst_menu_notasi) . "')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_hapus($mst_menu_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_mst_menu where mst_menu_kode='$mst_menu_kode'");
    }

    function aksi_tidak_tampil($mst_menu_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set
                                        mst_menu_status='2'
                                        where  mst_menu_kode='$mst_menu_kode'");
    }

    function aksi_tidak_aktif($mst_menu_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set
                                        mst_menu_status='1'
                                        where  mst_menu_kode='$mst_menu_kode'");
    }

    function aksi_aktif($mst_menu_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('menu');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set
                                        mst_menu_status='0'
                                        where  mst_menu_kode='$mst_menu_kode'");
    }
}
