<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Hadiah_pemenang extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_hadiah_pemenang', 'hadiah_pemenang');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah_pemenang');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Pemenang Hadiah';

        $this->template->load('includes/header', 'view_hadiah_pemenang', $data);
    }


    function aksi_statistik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah_pemenang');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        //PEMENANG
        if (strlen($txt_cari) > 0) {
            $pemenang_hadiah = $db_arifahpulsa_api->query("SELECT count(trx_hadiah_user_kode) as statistik_pemenang_jumlah from tbl_mst_user, tbl_trx_hadiah
                                        where
                                        trx_hadiah_user_kode=mst_user_kode and
                                        mst_user_kode LIKE '%$txt_cari%'
                                        OR
                                        trx_hadiah_user_kode=mst_user_kode and
                                        mst_user_nama_lengkap LIKE '%$txt_cari%'
                                        OR
                                        trx_hadiah_user_kode=mst_user_kode and
                                        mst_user_nomor_hp LIKE '%$txt_cari%'
                                        OR
                                        trx_hadiah_user_kode=mst_user_kode and
                                        mst_user_email LIKE '%$txt_cari%'
                                        OR
                                        trx_hadiah_user_kode=mst_user_kode and
                                        trx_hadiah_jenis LIKE '%$txt_cari%'
                                        OR
                                        trx_hadiah_user_kode=mst_user_kode and
                                        trx_hadiah_nama LIKE '%$txt_cari%'");
        } else {
            $pemenang_hadiah = $db_arifahpulsa_api->query("SELECT count(trx_hadiah_user_kode) as statistik_pemenang_jumlah from tbl_mst_user, tbl_trx_hadiah
                                        where  trx_hadiah_user_kode=mst_user_kode and trx_hadiah_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");
        }

        if ($pemenang_hadiah->num_rows() > 0) {
            foreach ($pemenang_hadiah->result() as $row) {
                $data['statistik_pemenang_jumlah'] = number_format($row->statistik_pemenang_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_pemenang_jumlah'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_hadiah_pemenang()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah_pemenang');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->hadiah_pemenang->get_datatables_cari($txt_cari);
        } else {
            $list = $this->hadiah_pemenang->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            //STATUS
            $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                        </div>
                        </button>
                    </div>";


            $row[] = $no;
            $row[] = $aksi;
            $row[] = $field->trx_hadiah_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->mst_user_nomor_hp;
            $row[] = $field->mst_user_email;
            $row[] = $field->trx_hadiah_nama;
            $row[] = number_format($field->trx_hadiah_harga, 0, ',', '.');
            $row[] = $field->trx_hadiah_jenis;
            $row[] = date("d M Y H:i:s", strtotime($field->trx_hadiah_tanggal));
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->hadiah_pemenang->count_all_cari($txt_cari),
                "recordsFiltered" => $this->hadiah_pemenang->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->hadiah_pemenang->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->hadiah_pemenang->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }

    function aksi_notifikasi()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah_pemenang');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_inbox_kode =  "INBOX-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
        $mst_inbox_tanggal = date('Y-m-d H:i:s');
        $notifikasi_user_kode = $this->input->post("notifikasi_user_kode");
        $notifikasi_judul = $this->input->post("notifikasi_judul");
        $notifikasi_isi = $this->input->post("notifikasi_isi");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$notifikasi_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //INSERT KE tbl_mst_inbox
            $db_arifahpulsa_api->query("insert into tbl_mst_inbox (
                        mst_inbox_kode, 
                        mst_inbox_user_kode, 
                        mst_inbox_jenis, 
                        mst_inbox_judul, 
                        mst_inbox_isi,
                        mst_inbox_tanggal,
                        mst_inbox_jangka_waktu,
                        mst_inbox_status) values (
                        '$mst_inbox_kode', 
                        '$notifikasi_user_kode', 
                        'Teks',
                        '" . str_replace("'", "\'", $notifikasi_judul) . "',
                        '" . str_replace("'", "\'", $notifikasi_isi) . "',
                        '$mst_inbox_tanggal',
                        '1',
                        '0')");

            //KIRIM NOTIFIKASI
            $title = $notifikasi_judul;
            $body =  strip_tags($notifikasi_isi);
            firebase_notification($title, $body, $mst_user_firebase);

            $data['notifikasi_status'] = '0';
            echo json_encode($data);
        } else {
            $data['notifikasi_status'] = '1';
            echo json_encode($data);
        }
    }
}
