<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Hadiah extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Hadiah';

        $this->template->load('includes/header', 'view_hadiah', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url_mst_hadiah_foto = 'http://141.11.241.178/arifahpulsa/admin/assets/upload/data-hadiah/';

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_hadiah 
                                          ORDER BY mst_hadiah_id DESC ");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>FOTO</th>
                        <th>NAMA</th>
                        <th>JENIS</th>
                        <th>HARGA</th>
                        <th>STOK</th>
                        <th>TERPAKAI</th>
                        <th>TANGGAL AWAL</th>
                        <th>TANGGAL AKHIR</th>
                        <th>KETERANGAN</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            if ($row->mst_hadiah_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_hadiah_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->mst_hadiah_kode . "')>SET TIDAK AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_hadiah_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->mst_hadiah_kode . "')>SET AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }

            //ISI
            if (strlen($row->mst_hadiah_keterangan) > 100) {
                $words = explode(' ', $row->mst_hadiah_keterangan);
                $limitedWords = array_slice($words, 0, 15);
                $mst_hadiah_keterangan = implode(' ', $limitedWords);
            } else {
                $mst_hadiah_keterangan = $row->mst_hadiah_keterangan;
            }


            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_mst_hadiah_status'>$status</td>";
            echo            "<td id='tbl_mst_hadiah_kode'>$row->mst_hadiah_kode</td>";
            echo            "<td id='tbl_mst_hadiah_foto'><img src='$url_mst_hadiah_foto" . "$row->mst_hadiah_foto' class='rounded' alt='$row->mst_hadiah_foto' style='width:70;height:70px;text-align:center'></td>";
            echo            "<td id='tbl_mst_hadiah_nama'>$row->mst_hadiah_nama</td>";
            echo            "<td id='tbl_mst_hadiah_jenis'>$row->mst_hadiah_jenis</td>";
            echo            "<td id='tbl_mst_hadiah_harga'>" . number_format($row->mst_hadiah_harga, 0, ',', '.') . "</td>";
            echo            "<td id='tbl_mst_hadiah_stok'>$row->mst_hadiah_stok</td>";
            echo            "<td id='tbl_mst_hadiah_terpakai'>$row->mst_hadiah_terpakai</td>";
            echo            "<td id='tbl_mst_hadiah_periode_awal'>" . date("d M Y H:i:s", strtotime($row->mst_hadiah_periode_awal)) . "</td>";
            echo            "<td id='tbl_mst_hadiah_periode_akhir'>" . date("d M Y H:i:s", strtotime($row->mst_hadiah_periode_akhir)) . "</td>";
            echo            "<td id='tbl_mst_hadiah_keterangan'>$mst_hadiah_keterangan</td> ";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
              
                $(document).ready(function () {
                    var table = $('#example1').DataTable({
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_hadiah_kode = $this->input->post("mst_hadiah_kode");
        $mst_hadiah_nama = $this->input->post("mst_hadiah_nama");
        $mst_hadiah_jenis = $this->input->post("mst_hadiah_jenis");
        $mst_hadiah_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_hadiah_harga"));
        $mst_hadiah_stok = $this->input->post("mst_hadiah_stok");
        $mst_hadiah_periode_awal = $this->input->post("mst_hadiah_periode_awal");
        $mst_hadiah_periode_akhir = $this->input->post("mst_hadiah_periode_akhir");
        $mst_hadiah_keterangan = $this->input->post("mst_hadiah_keterangan");

        //UPLOAD GAMBAR
        $config['upload_path'] = 'assets/upload/data-hadiah/';
        $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
        $config['remove_spaces'] = TRUE;
        $config['overwrite'] = TRUE;
        $config['max_size'] = '20000';
        $config['file_name'] = 'KTG-' . $mst_hadiah_kode . "-" . rand(0, 999);

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $this->upload->data();
        if ($this->upload->do_upload('mst_hadiah_foto')) {
            $img_foto = $this->upload->data();
            $mst_hadiah_foto = $img_foto['file_name'];
            $db_arifahpulsa_api->query("UPDATE tbl_mst_hadiah set
                                        mst_hadiah_foto='$mst_hadiah_foto',
                                        mst_hadiah_nama='" . str_replace("'", "\'", $mst_hadiah_nama) . "',
                                        mst_hadiah_jenis='$mst_hadiah_jenis',
                                        mst_hadiah_harga='$mst_hadiah_harga',
                                        mst_hadiah_stok='$mst_hadiah_stok',
                                        mst_hadiah_periode_awal='$mst_hadiah_periode_awal',
                                        mst_hadiah_periode_akhir='$mst_hadiah_periode_akhir',
                                        mst_hadiah_keterangan='" . str_replace(" '", "\'", $mst_hadiah_keterangan) . "',
                                        mst_hadiah_status='0'
                                        where mst_hadiah_kode='$mst_hadiah_kode'");
        } else {
            $db_arifahpulsa_api->query("UPDATE tbl_mst_hadiah set
                                        mst_hadiah_nama='" . str_replace("'", "\'", $mst_hadiah_nama) . "',
                                        mst_hadiah_jenis='$mst_hadiah_jenis',
                                        mst_hadiah_harga='$mst_hadiah_harga',
                                        mst_hadiah_stok='$mst_hadiah_stok',
                                        mst_hadiah_periode_awal='$mst_hadiah_periode_awal',
                                        mst_hadiah_periode_akhir='$mst_hadiah_periode_akhir',
                                        mst_hadiah_keterangan='" . str_replace(" '", "\'", $mst_hadiah_keterangan) . "',
                                        mst_hadiah_status='0'
                                        where mst_hadiah_kode='$mst_hadiah_kode'");
        }

        $data['edit_status'] = '0';
        echo json_encode($data);
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_hadiah_kode = $this->input->post("mst_hadiah_kode");
        $mst_hadiah_nama = $this->input->post("mst_hadiah_nama");
        $mst_hadiah_jenis = $this->input->post("mst_hadiah_jenis");
        $mst_hadiah_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_hadiah_harga"));
        $mst_hadiah_stok = $this->input->post("mst_hadiah_stok");
        $mst_hadiah_periode_awal = $this->input->post("mst_hadiah_periode_awal");
        $mst_hadiah_periode_akhir = $this->input->post("mst_hadiah_periode_akhir");
        $mst_hadiah_keterangan = $this->input->post("mst_hadiah_keterangan");

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_mst_hadiah where mst_hadiah_kode='$mst_hadiah_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {

            //UPLOAD GAMBAR
            $config['upload_path'] = 'assets/upload/data-hadiah/';
            $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
            $config['remove_spaces'] = TRUE;
            $config['overwrite'] = TRUE;
            $config['max_size'] = '20000';
            $config['file_name'] = 'KTG-' . $mst_hadiah_kode;

            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->data();
            if ($this->upload->do_upload('mst_hadiah_foto')) {
                $img_foto = $this->upload->data();
                $mst_hadiah_foto = $img_foto['file_name'];
            } else {
                $mst_hadiah_foto = "no_image.png";
            }

            $db_arifahpulsa_api->query("insert into tbl_mst_hadiah (
                                mst_hadiah_kode,
                                mst_hadiah_foto, 
								mst_hadiah_nama, 
                                mst_hadiah_jenis, 
                                mst_hadiah_harga, 
                                mst_hadiah_stok, 
                                mst_hadiah_periode_awal, 
                                mst_hadiah_periode_akhir,
                                mst_hadiah_keterangan,
								mst_hadiah_status) values (
                                '$mst_hadiah_kode', 
                                '$mst_hadiah_foto', 
							    '" . str_replace("'", "\'", $mst_hadiah_nama) . "',
                                '$mst_hadiah_jenis', 
                                '$mst_hadiah_harga', 
                                '$mst_hadiah_stok', 
                                '$mst_hadiah_periode_awal', 
                                '$mst_hadiah_periode_akhir', 
								 '" . str_replace("'", "\'", $mst_hadiah_keterangan) . "',
								'0')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_hapus($mst_hadiah_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_mst_hadiah where mst_hadiah_kode='$mst_hadiah_kode'");
    }

    function aksi_tidak_aktif($mst_hadiah_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_hadiah set
                                        mst_hadiah_status='1'
                                        where  mst_hadiah_kode='$mst_hadiah_kode'");
    }

    function aksi_aktif($mst_hadiah_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('hadiah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_hadiah set
                                        mst_hadiah_status='0'
                                        where  mst_hadiah_kode='$mst_hadiah_kode'");
    }
}
