<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Banner extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('banner');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Banner';

        $this->template->load('includes/header', 'view_banner', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('banner');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url_mst_banner_gambar = 'http://141.11.241.178/arifahpulsa/admin/assets/upload/data-banner/';

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_banner 
                                          ORDER BY mst_banner_isi ASC ");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>KATEGORI</th>
                        <th>TIPE</th>
                        <th>VIDEO</th>
                        <th>GAMBAR</th>
                        <th>JUDUL</th>
                        <th>ISI</th>
                        <th>LINK SELENGKAPNYA</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            if ($row->mst_banner_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_banner_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->mst_banner_kode . "')>SET TIDAK AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_banner_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->mst_banner_kode . "')>SET AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }

            //ISI
            if (strlen($row->mst_banner_isi) > 100) {
                $words = explode(' ', $row->mst_banner_isi);
                $limitedWords = array_slice($words, 0, 15);
                $mst_banner_isi = implode(' ', $limitedWords);
            } else {
                $mst_banner_isi = $row->mst_banner_isi;
            }


            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_mst_banner_status'>$status</td>";
            echo            "<td id='tbl_mst_banner_kode'>$row->mst_banner_kode</td>";
            echo            "<td id='tbl_mst_banner_kategori'>$row->mst_banner_kategori</td>";
            echo            "<td id='tbl_mst_banner_tipe'>$row->mst_banner_tipe</td>";
            echo            "<td id='tbl_mst_banner_video'>$row->mst_banner_video</td>";
            echo            "<td id='tbl_mst_banner_gambar'><img src='$url_mst_banner_gambar" . "$row->mst_banner_gambar' class='rounded' alt='$row->mst_banner_gambar' style='width:70;height:70px;text-align:center'></td>";
            echo            "<td id='tbl_mst_banner_judul'>$row->mst_banner_judul</td>";
            echo            "<td id='tbl_mst_banner_isi'>$mst_banner_isi</td> ";
            echo            "<td id='tbl_mst_banner_link'>$row->mst_banner_link</td> ";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
              
                $(document).ready(function () {
                    var table = $('#example1').DataTable({
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('banner');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_banner_kategori = $this->input->post("mst_banner_kategori");
        $mst_banner_tipe = $this->input->post("mst_banner_tipe");
        $mst_banner_video = $this->input->post("mst_banner_video");
        $mst_banner_kode = $this->input->post("mst_banner_kode");
        $mst_banner_judul = $this->input->post("mst_banner_judul");
        $mst_banner_isi = $this->input->post("mst_banner_isi");
        $mst_banner_link = $this->input->post("mst_banner_link");

        //UPLOAD GAMBAR
        $config['upload_path'] = 'assets/upload/data-banner/';
        $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
        $config['remove_spaces'] = TRUE;
        $config['overwrite'] = TRUE;
        $config['max_size'] = '20000';
        $config['file_name'] = 'KTG-' . $mst_banner_kode . "-" . rand(0, 999);

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $this->upload->data();
        if ($this->upload->do_upload('mst_banner_gambar')) {
            $img_foto = $this->upload->data();
            $mst_banner_gambar = $img_foto['file_name'];
            $db_arifahpulsa_api->query("UPDATE tbl_mst_banner set
                                        mst_banner_kategori='$mst_banner_kategori',
                                        mst_banner_tipe='$mst_banner_tipe',
                                        mst_banner_video='$mst_banner_video',
                                        mst_banner_gambar='$mst_banner_gambar',
                                        mst_banner_judul='" . str_replace("'", "\'", $mst_banner_judul) . "',
                                        mst_banner_isi='" . str_replace(" '", "\'", $mst_banner_isi) . "',
                                        mst_banner_status='0',
                                        mst_banner_link='$mst_banner_link'
                                        where mst_banner_kode='$mst_banner_kode'");
        } else {
            $db_arifahpulsa_api->query("UPDATE tbl_mst_banner set
                                        mst_banner_kategori='$mst_banner_kategori',
                                        mst_banner_tipe='$mst_banner_tipe',
                                        mst_banner_video='$mst_banner_video',
                                        mst_banner_judul='" . str_replace("'", "\'", $mst_banner_judul) . "',
                                        mst_banner_isi='" . str_replace(" '", "\'", $mst_banner_isi) . "',
                                        mst_banner_status='0',
                                        mst_banner_link='$mst_banner_link'
                                        where mst_banner_kode='$mst_banner_kode'");
        }

        $data['edit_status'] = '0';
        echo json_encode($data);
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('banner');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_banner_kategori = $this->input->post("mst_banner_kategori");
        $mst_banner_tipe = $this->input->post("mst_banner_tipe");
        $mst_banner_video = $this->input->post("mst_banner_video");
        $mst_banner_kode = $this->input->post("mst_banner_kode");
        $mst_banner_judul = $this->input->post("mst_banner_judul");
        $mst_banner_isi = $this->input->post("mst_banner_isi");
        $mst_banner_link = $this->input->post("mst_banner_link");

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_mst_banner where mst_banner_kode='$mst_banner_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {

            //UPLOAD GAMBAR
            $config['upload_path'] = 'assets/upload/data-banner/';
            $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
            $config['remove_spaces'] = TRUE;
            $config['overwrite'] = TRUE;
            $config['max_size'] = '20000';
            $config['file_name'] = 'KTG-' . $mst_banner_kode;

            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->data();
            if ($this->upload->do_upload('mst_banner_gambar')) {
                $img_foto = $this->upload->data();
                $mst_banner_gambar = $img_foto['file_name'];
            } else {
                $mst_banner_gambar = "no_image.png";
            }

            $db_arifahpulsa_api->query("insert into tbl_mst_banner (
                                mst_banner_kode,
                                mst_banner_kategori,
                                mst_banner_tipe,
                                mst_banner_video,
                                mst_banner_gambar, 
								mst_banner_judul, 
                                mst_banner_isi,
                                mst_banner_link,
								mst_banner_status) values (
                                '$mst_banner_kode', 
                                '$mst_banner_kategori', 
                                '$mst_banner_tipe', 
                                '$mst_banner_video', 
                                '$mst_banner_gambar', 
							    '" . str_replace("'", "\'", $mst_banner_judul) . "',
								'" . str_replace("'", "\'", $mst_banner_isi) . "',
                                '$mst_banner_link', 
								'0')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_hapus($mst_banner_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('banner');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_mst_banner where mst_banner_kode='$mst_banner_kode'");
    }

    function aksi_tidak_aktif($mst_banner_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('banner');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_banner set
                                        mst_banner_status='1'
                                        where  mst_banner_kode='$mst_banner_kode'");
    }

    function aksi_aktif($mst_banner_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('banner');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_banner set
                                        mst_banner_status='0'
                                        where  mst_banner_kode='$mst_banner_kode'");
    }
}
